/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPrivateKey;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAPrivateKey;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.spec.ECDSAPrivateKeySpec;
import iaik.security.ecc.spec.ECDSAPublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class ECDSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$iaik$security$ecc$spec$ECDSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$iaik$security$ecc$spec$ECDSAPublicKeySpec;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECDSAPublicKey) {
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)key;
            ECDSAParameter eCDSAParameter = new ECDSAParameter(eCDSAPublicKey.getParameter().getG(), eCDSAPublicKey.getParameter().getR(), eCDSAPublicKey.getParameter().getK());
            return new ECPublicKey(eCDSAParameter, eCDSAPublicKey.getW());
        }
        if (key instanceof ECDSAPrivateKey) {
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)key;
            ECDSAParameter eCDSAParameter = new ECDSAParameter(eCDSAPrivateKey.getParameter().getG(), eCDSAPrivateKey.getParameter().getR(), eCDSAPrivateKey.getParameter().getK());
            return new ECPrivateKey(eCDSAParameter, eCDSAPrivateKey.getS(), null);
        }
        throw new InvalidKeyException("Only keys of type ECDSAPublicKey and ECDSAPrivateKey can be translated.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof ECPublicKey) {
            if ((class$iaik$security$ecc$spec$ECDSAPublicKeySpec == null ? (class$iaik$security$ecc$spec$ECDSAPublicKeySpec = ECDSAKeyFactory.class$("iaik.security.ecc.spec.ECDSAPublicKeySpec")) : class$iaik$security$ecc$spec$ECDSAPublicKeySpec).isAssignableFrom(clazz)) {
                ECPublicKey eCPublicKey = (ECPublicKey)key;
                ECDSAParameter eCDSAParameter = (ECDSAParameter)eCPublicKey.getParameter();
                return new ECDSAPublicKeySpec(eCPublicKey.getW(), eCDSAParameter.getR(), eCDSAParameter.getK(), eCDSAParameter.getG());
            }
            if ((class$java$security$spec$X509EncodedKeySpec == null ? (class$java$security$spec$X509EncodedKeySpec = ECDSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) : class$java$security$spec$X509EncodedKeySpec).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert to this key spec");
        }
        if (key instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            if ((class$iaik$security$ecc$spec$ECDSAPrivateKeySpec == null ? (class$iaik$security$ecc$spec$ECDSAPrivateKeySpec = ECDSAKeyFactory.class$("iaik.security.ecc.spec.ECDSAPrivateKeySpec")) : class$iaik$security$ecc$spec$ECDSAPrivateKeySpec).isAssignableFrom(clazz)) {
                ECDSAParameter eCDSAParameter = (ECDSAParameter)eCPrivateKey.getParameter();
                return new ECDSAPrivateKeySpec(eCPrivateKey.getS(), eCDSAParameter.getR(), eCDSAParameter.getK(), eCDSAParameter.getG());
            }
            if ((class$java$security$spec$PKCS8EncodedKeySpec == null ? (class$java$security$spec$PKCS8EncodedKeySpec = ECDSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) : class$java$security$spec$PKCS8EncodedKeySpec).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert to this key spec");
        }
        throw new InvalidKeySpecException("Can only convert ECDSA keys");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECDSAPublicKeySpec) {
                return new ECPublicKey((ECDSAPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new ECPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Unsupported key spec");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECDSAPrivateKeySpec) {
                ECDSAPrivateKeySpec eCDSAPrivateKeySpec = (ECDSAPrivateKeySpec)keySpec;
                return new ECPrivateKey(eCDSAPrivateKeySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new ECPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
        throw new InvalidKeySpecException("KeySpec not supported");
    }
}

