/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageImprint {
    private byte[] a;
    private AlgorithmID b;
    private static final int d = 1;
    private static final int e = 0;
    private static final int c = 2;

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Parsed MessageImprint is not a SEQUENCE");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        if (sEQUENCE.countComponents() != 2) {
            throw new CodingException("Wrong number of elements in MessageImprint SEQUENCE. Found " + sEQUENCE.countComponents() + " elements.");
        }
        this.b = new AlgorithmID(sEQUENCE.getComponentAt(0));
        if (!sEQUENCE.getComponentAt(1).isA(ASN.OCTET_STRING)) {
            throw new CodingException("MessageImprint.hashedMessage is not a OCTET_STRING");
        }
        this.a = (byte[])sEQUENCE.getComponentAt(1).getValue();
    }

    public static byte[] calculateHash(byte[] byArray, AlgorithmID algorithmID) throws NullPointerException, NoSuchAlgorithmException {
        if (byArray == null) {
            throw new NullPointerException("Argument \"toBeHashed\" must not be null");
        }
        if (algorithmID == null) {
            throw new NullPointerException("Argument \"hashAlgorithm\" must not be null");
        }
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmID.getName());
        return messageDigest.digest(byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Message Imprint>\n");
        stringBuffer.append("\tHash Algorithm: " + this.b.toString() + "\n");
        stringBuffer.append("\tHashed Message: " + Util.toString((byte[])this.a) + "\n");
        stringBuffer.append("</Message Imprint>");
        return stringBuffer.toString();
    }

    public byte[] getHashedMessage() {
        return this.a;
    }

    public void setHashedMessage(byte[] byArray) {
        this.a = byArray;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.b;
    }

    public void setHashAlgorithm(AlgorithmID algorithmID) throws NullPointerException {
        if (algorithmID == null) {
            throw new NullPointerException("Argument \"hash_algorithm\" must not be null");
        }
        this.b = algorithmID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MessageImprint)) {
            return false;
        }
        MessageImprint messageImprint = (MessageImprint)object;
        if (!this.b.equals((Object)messageImprint.b)) {
            return false;
        }
        if (this.a.length != messageImprint.a.length) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n] != messageImprint.a[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.a));
        return sEQUENCE;
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public MessageImprint(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public MessageImprint(AlgorithmID algorithmID, byte[] byArray) throws NullPointerException {
        if (algorithmID == null) {
            throw new NullPointerException("Argument \"hash_algorithm\" must not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"hashed_message\" must not be null");
        }
        this.b = algorithmID;
        this.a = byArray;
    }
}

