/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.campi.CodAttModel;
import finanze.IDTE.studi2002.campi.CodFiscModel;
import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.campi.RangeNumericModel;
import finanze.IDTE.studi2002.main.Anomalia;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveAnnotazione;
import finanze.IDTE.studi2002.posizione.ChiaveStudio;
import finanze.IDTE.studi2002.posizione.SezioneTabella;
import finanze.IDTE.studi2002.posizione.StrutturaMultiposizione;
import finanze.IDTE.studi2002.risorse.InterpreteTabellaSet;
import finanze.IDTE.studi2002.risorse.RigaTabellaBeanModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GestoreFornituraAS
implements Enumeration {
    private static final String CHAR_TESTA = "0";
    private static final String CHAR_CODA = "9";
    private static final int LUNGHEZZA_RECORD = 1900;
    private byte[] dati = null;
    private Vector messaggioErrore = null;
    private int inizio;
    private int fine;
    private static final int POSIZIONE_NUMERO_RECORD = 77;
    private static final int LUNGHEZZA_POSIZIONE_NUMERO_RECORD = 8;
    private Vector struttureMultiposizione = null;
    private int numeroRecordPerStudio = 0;
    private ChiaveAnnotazione chiaveQ = null;
    private int inizioMultiposizione;

    public GestoreFornituraAS(byte[] dati) {
        this.dati = dati;
        this.struttureMultiposizione = new Vector();
        this.messaggioErrore = new Vector();
        this.inizioMultiposizione = 1900;
        this.inizio = 0;
    }

    private boolean controllaChiavi(StrutturaMultiposizione[] dati) {
        if (dati == null || dati.length == 0) {
            return false;
        }
        ChiaveAnnotazione chiaveQ = (ChiaveAnnotazione)dati[0].getChiave();
        int i = 2;
        while (i < dati.length) {
            ChiaveStudio chiaveStudio = (ChiaveStudio)dati[i].getChiave();
            if (chiaveQ.isEuro() != chiaveStudio.getEuro()) {
                String campi = String.valueOf(chiaveStudio.getCodiceAttivita()) + "*" + chiaveStudio.getProgressivo();
                Anomalia anomalia = new Anomalia(chiaveQ, "Q", "scarto_confermabile", "310", campi);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            if (chiaveStudio.getModelloDic().length() > 0 && chiaveQ.getModelloDichiarazione() != Integer.parseInt(chiaveStudio.getModelloDic())) {
                String campi = String.valueOf(chiaveStudio.getCodiceAttivita()) + "*" + chiaveStudio.getProgressivo();
                Anomalia anomalia = new Anomalia(chiaveQ, "Q", "scarto_confermabile", "311", campi);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean controllaNumeroRecordPerStudio(boolean flag) {
        if (this.numeroRecordPerStudio == 1) {
            this.fine -= 1900;
            return true;
        }
        if (this.numeroRecordPerStudio > 0) {
            StrutturaMultiposizione temp = null;
            if (this.controllaRichiestaMarginalita()) {
                temp = this.creaST();
            }
            if (temp == null) {
                return true;
            }
            this.struttureMultiposizione.addElement(temp);
            if (flag) {
                this.numeroRecordPerStudio = 1;
            }
        } else if (flag) {
            ++this.numeroRecordPerStudio;
        }
        return false;
    }

    private boolean controllaRichiestaMarginalita() {
        int i = 2;
        while (i < this.struttureMultiposizione.size()) {
            StrutturaMultiposizione recordS = (StrutturaMultiposizione)this.struttureMultiposizione.elementAt(i);
            if (recordS.getTipo().equalsIgnoreCase("S") && Integer.parseInt((String)recordS.getCampi().get("FlagRichiestaMarginalita")) == 1) {
                Anomalia anomalia = new Anomalia(recordS.getChiave(), "S", "scarto_confermabile", "312");
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean controllaSequenza() {
        if (this.struttureMultiposizione.size() < 2) {
            Anomalia anomalia = new Anomalia(new ChiaveStudio(""), "Q", "scarto", "313");
            this.messaggioErrore.addElement(anomalia);
            return false;
        }
        StrutturaMultiposizione recordQ = (StrutturaMultiposizione)this.struttureMultiposizione.elementAt(0);
        StrutturaMultiposizione recordR = (StrutturaMultiposizione)this.struttureMultiposizione.elementAt(1);
        if (!recordQ.getTipo().equalsIgnoreCase("Q") || !recordR.getTipo().equalsIgnoreCase("R")) {
            Anomalia anomalia = new Anomalia(recordQ.getChiave(), "Q", "scarto", "314");
            this.messaggioErrore.addElement(anomalia);
            return false;
        }
        if (!((ChiaveAnnotazione)recordQ.getChiave()).equals(recordR.getChiave())) {
            Anomalia anomalia = new Anomalia(recordQ.getChiave(), "Q", "scarto", "315");
            this.messaggioErrore.addElement(anomalia);
            return false;
        }
        int i = 2;
        while (i < this.struttureMultiposizione.size()) {
            StrutturaMultiposizione recordS = (StrutturaMultiposizione)this.struttureMultiposizione.elementAt(i);
            if (recordS.getTipo().equalsIgnoreCase("S")) {
                if (!((ChiaveAnnotazione)recordQ.getChiave()).equals(recordS.getChiave())) {
                    Anomalia anomalia = new Anomalia(recordQ.getChiave(), "Q", "scarto", "316");
                    this.messaggioErrore.addElement(anomalia);
                    return false;
                }
            } else {
                Anomalia anomalia = new Anomalia(recordQ.getChiave(), "Q", "scarto", "314");
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            ++i;
        }
        return true;
    }

    private ChiaveAnnotazione creaChiaveQ(int inizioRecord) {
        Anomalia anomalia;
        String codiceFiscale = null;
        int anno = 0;
        int modelloDichiarazione = -1;
        boolean euro = false;
        boolean omocodice = false;
        String campo = null;
        try {
            campo = "Omocodice";
            omocodice = this.getValore(inizioRecord + 106, 1).equals("1");
            campo = "Modello Dichiarazione";
            modelloDichiarazione = Integer.parseInt(this.getValore(inizioRecord + 98, 2));
            campo = "Euro";
            euro = this.getValore(inizioRecord + 104, 1).equals("1");
        }
        catch (NumberFormatException numberFormatException) {
            Anomalia anomalia2 = new Anomalia(new ChiaveStudio(""), "Q", "scarto", "011", campo);
            this.messaggioErrore.addElement(anomalia2);
        }
        CodFiscModel codFiscModel = new CodFiscModel("CodiceFiscale", "Codice fiscale", true);
        try {
            codFiscModel.setOmo(omocodice);
            codFiscModel.setValore(this.getValore(inizioRecord + 1, 16).trim());
            codiceFiscale = codFiscModel.getValue();
            codFiscModel.setModelloDichiarazione(modelloDichiarazione);
        }
        catch (ControlloFormaleException controlloFormaleException) {
            anomalia = new Anomalia((Chiave)new ChiaveStudio(""), "Q", codFiscModel);
            this.messaggioErrore.addElement(anomalia);
        }
        catch (NonCoerenzaException nonCoerenzaException) {
            anomalia = new Anomalia((Chiave)new ChiaveStudio(""), "Q", codFiscModel);
            this.messaggioErrore.addElement(anomalia);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            anomalia = new Anomalia((Chiave)new ChiaveStudio(""), "Q", codFiscModel);
            this.messaggioErrore.addElement(anomalia);
        }
        RangeNumericModel rangeNumericModel = new RangeNumericModel("Anno", "Anno modello", 4, 2002L, 2002L);
        try {
            rangeNumericModel.setValore(this.getValore(inizioRecord + 94, 4));
            anno = Integer.parseInt(rangeNumericModel.getValue());
        }
        catch (ControlloFormaleException controlloFormaleException) {
            Anomalia anomalia3 = new Anomalia((Chiave)new ChiaveStudio(codFiscModel.getValue()), "Q", rangeNumericModel);
            this.messaggioErrore.addElement(anomalia3);
        }
        ChiaveAnnotazione chiave = new ChiaveAnnotazione(codiceFiscale, anno);
        chiave.setOmocodice(omocodice);
        chiave.setModelloDichiarazione(modelloDichiarazione);
        chiave.setEuro(euro);
        return chiave;
    }

    private ChiaveAnnotazione creaChiaveR(int fine) {
        try {
            return new ChiaveAnnotazione(this.getValore(fine + 1, 16).trim(), Integer.parseInt(this.getValore(fine + 94, 4)));
        }
        catch (NumberFormatException numberFormatException) {
            Anomalia anomalia = new Anomalia(this.chiaveQ, "R", "scarto", "011", "Anno");
            this.messaggioErrore.addElement(anomalia);
            return null;
        }
    }

    private ChiaveStudio creaChiaveS(int indice) {
        String codiceFiscale = "";
        int anno = 0;
        int modelloDichiarazione = -1;
        boolean euro = false;
        boolean omocodice = false;
        String campo = null;
        try {
            campo = "Omocodice";
            omocodice = this.getValore(indice + 287, 1).equals("1");
            campo = "Modello Dichiarazione";
            modelloDichiarazione = Integer.parseInt(this.getValore(indice + 100, 2));
            campo = "Euro";
            euro = this.getValore(indice + 284, 1).equals("1");
        }
        catch (NumberFormatException numberFormatException) {
            Anomalia anomalia = new Anomalia(new ChiaveStudio(codiceFiscale), "S", "scarto", "011", campo);
            this.messaggioErrore.addElement(anomalia);
        }
        String codiceAttivita = null;
        String progressivo = null;
        String codiceStudio = null;
        CodFiscModel codFiscModel = new CodFiscModel("CodiceFiscale", "Codice fiscale", true);
        try {
            codFiscModel.setOmo(omocodice);
            codFiscModel.setValore(this.getValore(indice + 1, 16).trim());
            codiceFiscale = codFiscModel.getValue();
        }
        catch (ControlloFormaleException controlloFormaleException) {
            Anomalia anomalia = new Anomalia((Chiave)new ChiaveStudio(codiceFiscale), "S", codFiscModel);
            this.messaggioErrore.addElement(anomalia);
        }
        CodAttModel codAttModel = new CodAttModel("CodiceAttivita", "Codice attivita'", "S");
        try {
            codAttModel.setValore(this.getValore(indice + 89, 5));
            codiceAttivita = codAttModel.getValue();
            codiceStudio = codAttModel.getCodiceStudio();
        }
        catch (ControlloFormaleException controlloFormaleException) {
            Anomalia anomalia = new Anomalia((Chiave)new ChiaveStudio(codiceFiscale), "S", codAttModel);
            this.messaggioErrore.addElement(anomalia);
        }
        RangeNumericModel rangeAnno = new RangeNumericModel("Anno", "Anno modello", 4, 2002L, 2002L);
        try {
            rangeAnno.setValore(this.getValore(indice + 94, 4));
            anno = Integer.parseInt(rangeAnno.getValue());
        }
        catch (ControlloFormaleException controlloFormaleException) {
            Anomalia anomalia = new Anomalia((Chiave)new ChiaveStudio(codiceFiscale), "S", rangeAnno);
            this.messaggioErrore.addElement(anomalia);
        }
        RangeNumericModel rangeProgressivo = new RangeNumericModel("Progressivo", "Numero progressivo unita' produttiva", 2, 1L, 99L);
        try {
            rangeProgressivo.setValore(this.getValore(indice + 98, 2));
            progressivo = String.valueOf(Integer.parseInt(rangeProgressivo.getValue()));
        }
        catch (ControlloFormaleException controlloFormaleException) {
            Anomalia anomalia = new Anomalia((Chiave)new ChiaveStudio(codiceFiscale), "S", rangeProgressivo);
            this.messaggioErrore.addElement(anomalia);
        }
        ChiaveStudio chiave = new ChiaveStudio(codiceFiscale, anno, codiceAttivita, progressivo, codiceStudio);
        chiave.setOmocodice(omocodice);
        chiave.setEuro(euro);
        chiave.setModelloDic(String.valueOf(modelloDichiarazione));
        chiave.setTipoReddito(1);
        return chiave;
    }

    private ChiaveStudio creaChiaveT(int indice, String codiceStudio) {
        String codiceFiscale = this.getValore(indice, 16).trim();
        int anno = 0;
        try {
            anno = Integer.parseInt(this.getValore(indice + 93, 4));
        }
        catch (NumberFormatException numberFormatException) {
            Anomalia anomalia = new Anomalia(this.chiaveQ, "T", "scarto", "011", "Anno");
            this.messaggioErrore.addElement(anomalia);
        }
        String codiceAttivita = this.getValore(indice + 88, 5).trim();
        String progressivo = "";
        try {
            progressivo = String.valueOf(Integer.parseInt(this.getValore(indice + 97, 2).trim()));
        }
        catch (NumberFormatException numberFormatException) {
            Anomalia anomalia = new Anomalia(this.chiaveQ, "T", "scarto", "011", "Progressivo");
            this.messaggioErrore.addElement(anomalia);
        }
        return new ChiaveStudio(codiceFiscale, anno, codiceAttivita, progressivo, codiceStudio);
    }

    private StrutturaMultiposizione creaQ() {
        InterpreteTabellaSet interpreteTabella = new InterpreteTabellaSet("testam.ger");
        SezioneTabella[] sezioniTabella = interpreteTabella.getSezioni();
        Hashtable campi = new Hashtable();
        int indice = this.fine + 1;
        if (!this.impostaCampiNonPosizionali(indice = this.impostaCampiPosizionali(indice, campi, sezioniTabella), campi, "Q")) {
            return null;
        }
        Enumeration e = campi.keys();
        int max = 0;
        while (e.hasMoreElements()) {
            String codice = (String)e.nextElement();
            if (codice.length() != 6 || !codice.startsWith("M")) continue;
            max = Math.max(Integer.parseInt(codice.substring(1)), max);
        }
        return new StrutturaMultiposizione(this.chiaveQ, "Q", campi);
    }

    private boolean creaQR() {
        StrutturaMultiposizione temp = this.creaQ();
        if (temp == null) {
            this.fine += 1900;
            return true;
        }
        this.struttureMultiposizione.addElement(temp);
        this.fine += 1900;
        temp = this.creaR();
        if (temp == null) {
            return true;
        }
        this.struttureMultiposizione.addElement(temp);
        return false;
    }

    private StrutturaMultiposizione creaR() {
        InterpreteTabellaSet interpreteTabella = new InterpreteTabellaSet("testan.ger");
        SezioneTabella[] sezioniTabella = interpreteTabella.getSezioni();
        Hashtable campi = new Hashtable();
        int indice = this.fine + 1;
        if (!this.impostaCampiNonPosizionali(indice = this.impostaCampiPosizionali(indice, campi, sezioniTabella), campi, "R")) {
            return null;
        }
        return new StrutturaMultiposizione(this.chiaveQ, "R", campi);
    }

    private StrutturaMultiposizione creaST() {
        int top;
        int indice = top = this.fine - 1900 * this.numeroRecordPerStudio;
        String tipo = this.getValore(indice, 1);
        ChiaveStudio chiaveS = null;
        Hashtable campi = null;
        if (this.numeroRecordPerStudio < 2) {
            Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "317");
            this.messaggioErrore.addElement(anomalia);
            return null;
        }
        if (tipo.equalsIgnoreCase("S")) {
            chiaveS = this.creaChiaveS(indice);
            if (this.messaggioErrore.size() > 0) {
                return null;
            }
            if (!this.chiaveQ.equals(chiaveS)) {
                Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "316");
                this.messaggioErrore.addElement(anomalia);
                return null;
            }
            String codiceStudio = chiaveS.getCodiceStudio().toLowerCase();
            InterpreteTabellaSet interpreteTesta = new InterpreteTabellaSet("testa.ger");
            InterpreteTabellaSet interpreteTabella = new InterpreteTabellaSet("" + codiceStudio + ".ger");
            SezioneTabella[] sezioniTesta = interpreteTesta.getSezioni();
            SezioneTabella[] sezioniTabella = interpreteTabella.getSezioniPerTipo("S");
            campi = new Hashtable();
            int cfr_ignored_0 = ++indice / 1900;
            indice = this.impostaCampiPosizionali(indice, campi, sezioniTesta);
            indice = this.impostaCampiPosizionali(indice, campi, sezioniTabella) + 2;
            int i = 1;
            while (i < this.numeroRecordPerStudio) {
                ChiaveStudio chiaveT;
                tipo = this.getValore(indice, 1);
                if ((chiaveT = this.creaChiaveT(++indice, codiceStudio)).equals(chiaveS)) {
                    if (!this.impostaCampiNonPosizionali(indice = this.impostaCampiPosizionali(indice, campi, sezioniTesta), campi, "T")) {
                        return null;
                    }
                } else {
                    Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "318");
                    this.messaggioErrore.addElement(anomalia);
                    return null;
                }
                indice = top + (i + 1) * 1900;
                ++i;
            }
        } else {
            Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "314");
            this.messaggioErrore.addElement(anomalia);
            return null;
        }
        this.numeroRecordPerStudio = 0;
        return new StrutturaMultiposizione(chiaveS, "S", campi);
    }

    public Vector getMessaggioErrore() {
        return this.messaggioErrore;
    }

    int getNumeroRighe() {
        return this.dati.length / 1900;
    }

    int getNumeroRigheLette() {
        return this.fine / 1900;
    }

    private String getValore(int inizio, int lunghezza) {
        return new String(this.dati, inizio, lunghezza);
    }

    public boolean hasMoreElements() {
        this.messaggioErrore = new Vector();
        if (this.inizio == this.dati.length) {
            return false;
        }
        if (this.trovaRecordQR()) {
            this.fine = this.inizio;
            if (this.creaQR()) {
                return true;
            }
            this.fine += 1900;
            while (this.fine < this.dati.length) {
                String str = this.getValore(this.fine, 1);
                if (str.equalsIgnoreCase("S")) {
                    if (this.controllaNumeroRecordPerStudio(true)) {
                        return true;
                    }
                } else if (str.equalsIgnoreCase("T")) {
                    ++this.numeroRecordPerStudio;
                } else {
                    this.inizioMultiposizione = this.fine;
                    if (!this.controllaNumeroRecordPerStudio(false)) break;
                    return true;
                }
                this.fine += 1900;
            }
            if (this.fine == this.dati.length && this.numeroRecordPerStudio > 0) {
                StrutturaMultiposizione temp = null;
                if (this.controllaRichiestaMarginalita()) {
                    temp = this.creaST();
                }
                if (temp == null) {
                    Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "319");
                    this.messaggioErrore.addElement(anomalia);
                    return false;
                }
                this.struttureMultiposizione.addElement(temp);
            }
        } else {
            this.fine = this.inizio;
            return this.inizio < this.dati.length - 1900;
        }
        return this.inizio < this.fine;
    }

    private boolean impostaCampiNonPosizionali(int indice, Hashtable campi, String tipoRecord) {
        while (indice < this.fine + 1900) {
            String codice = new String(this.dati, indice, 6).toUpperCase();
            if (codice.trim().length() <= 0) break;
            String valore = new String(this.dati, indice + 6, 11).trim();
            if (campi.containsKey(codice)) {
                Anomalia anomalia = new Anomalia(this.chiaveQ, tipoRecord, "scarto_confermabile", "808", codice);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            campi.put(codice, valore);
            indice += 17;
        }
        return true;
    }

    private int impostaCampiPosizionali(int n, Hashtable campi, SezioneTabella[] sezioni) {
        int indice;
        int i = 0;
        while (i < sezioni.length) {
            if (sezioni[i].getTipologiaReddito() != null && sezioni[i].getTipologiaReddito().equals("2")) {
                ++i;
            }
            RigaTabellaBeanModel[] righeTabella = sezioni[i].getRigheBeansModel();
            int j = 0;
            while (j < righeTabella.length) {
                int lunghezza = righeTabella[j].getLunghezza();
                String valore = new String(this.dati, n, lunghezza);
                if (!righeTabella[j].isSolaScrittura()) {
                    campi.put(righeTabella[j].getCodice(), valore);
                } else {
                    righeTabella[j].getCodice();
                }
                indice = n + lunghezza;
                ++j;
            }
            ++i;
        }
        return indice;
    }

    public Object nextElement() {
        Object[] sm = new StrutturaMultiposizione[this.struttureMultiposizione.size()];
        this.struttureMultiposizione.copyInto(sm);
        this.struttureMultiposizione.removeAllElements();
        this.inizio = this.fine;
        this.numeroRecordPerStudio = 0;
        this.controllaChiavi((StrutturaMultiposizione[])sm);
        return sm;
    }

    private boolean trovaRecordQR() {
        int i = this.inizio;
        while (!(this.inizio >= this.dati.length || this.getValore(this.inizio, 1).equalsIgnoreCase("Q") && this.getValore(this.inizio + 1900, 1).equalsIgnoreCase("R"))) {
            this.inizio += 1900;
        }
        if (this.inizio <= this.dati.length) {
            if (i < this.inizio) {
                int cfr_ignored_0 = this.inizioMultiposizione / 1900;
                int recordFinale = this.inizio / 1900;
                if (this.inizio == this.dati.length) {
                    --recordFinale;
                }
                Anomalia anomalia = new Anomalia(new ChiaveStudio(""), "Q", "scarto", "319");
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
            this.inizioMultiposizione = this.inizio;
            this.chiaveQ = this.creaChiaveQ(this.inizio);
            if (this.messaggioErrore.size() > 0) {
                this.inizio += 1900;
                return false;
            }
            ChiaveAnnotazione chiaveR = this.creaChiaveR(this.inizio + 1900);
            if (this.messaggioErrore.size() > 0) {
                this.inizio += 1900;
                return false;
            }
            if (this.chiaveQ.equals(chiaveR)) {
                return true;
            }
            Anomalia anomalia = new Anomalia(this.chiaveQ, "Q", "scarto", "315");
            this.messaggioErrore.addElement(anomalia);
            return false;
        }
        return false;
    }
}

