/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.ProgressDialog;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CacheViewDialog
extends WindowAdapter
implements ActionListener {
    private ProgressDialog progressDialog = null;
    private int answer = -1;
    private boolean isVisible = false;
    private boolean allowVisible = false;
    private AppInfo ainfo = null;
    private int percentComplete = 0;
    private URL currentUrl = null;
    private boolean isCanceled = false;
    private boolean exitOnCancel = false;
    private boolean includeOk = false;
    private String statusString = null;
    private static final int TIMER_UPDATE_RATE = 1500;
    private static final int TIMER_INITIAL_DELAY = 8000;
    private static final int TIMER_RECENT_SIZE = 10;
    Timer timerObject = null;
    private int[] timerDownloadPercents = new int[10];
    private int timerCount = 0;
    private int timerLastPercent = 0;
    private boolean timerOn = false;
    private String pendingHeading;

    public void initialize(Object object, AppInfo appInfo, boolean bl, boolean bl2, boolean bl3) {
        this.isCanceled = false;
        this.exitOnCancel = bl;
        this.includeOk = bl2;
        if (this.ainfo != null) {
            this.ainfo = appInfo;
        } else {
            this.ainfo = new AppInfo();
            this.ainfo.setTitle(" ");
            if (bl3) {
                this.ainfo.setVendor(" ");
            }
        }
        String string = ResourceManager.getString((String)"product.javaws.name", (String)"");
        if (this.progressDialog == null) {
            this.progressDialog = UIFactory.createProgressDialog((AppInfo)this.ainfo, (Component)((Component)object), (String)string, null, (boolean)bl2);
        } else {
            this.progressDialog.reset(this.ainfo, string, bl2);
        }
        this.progressDialog.getDialog().addWindowListener(this);
    }

    public void initialize(Object object, boolean bl) {
        this.initialize(object, null, false, false, bl);
    }

    public Component getOwner() {
        if (this.progressDialog == null) {
            return null;
        }
        return this.progressDialog.getDialog();
    }

    public void showLoadingProgressScreen() {
        this.setHeading(ResourceManager.getString((String)"progress.downloading"), true);
        this.timerObject = new Timer(1500, this);
        this.timerCount = 0;
        this.timerObject.start();
    }

    public void setStatus(String string) {
        this.statusString = string;
        this.setStatusStringText(string);
    }

    private void setEstimatedTime(String string) {
        if (this.statusString == null || this.statusString.length() == 0) {
            this.setStatusStringText(string);
        }
    }

    private void setStatusStringText(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    CacheViewDialog.this.progressDialog.setProgressStatusText(string);
                }
            }
        };
        this.invokeLater(runnable);
    }

    public void setHeading(final String string, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    CacheViewDialog.this.progressDialog.setMasthead(string == null ? " " : string, bl);
                }
            }
        };
        this.pendingHeading = null;
        this.invokeLater(runnable);
    }

    public void setHeadingLater(String string) {
        if (this.timerObject != null && this.timerObject.isRunning()) {
            this.pendingHeading = string;
        } else {
            this.setHeading(string, true);
        }
    }

    public void setProgressBarVisible(final boolean bl) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    int n = bl ? 0 : 9999;
                    CacheViewDialog.this.progressDialog.showProgress(n);
                }
            }
        });
    }

    public void setProgressBarValue(final int n) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    CacheViewDialog.this.progressDialog.showProgress(n);
                }
            }
        });
    }

    public void setIndeterminate(final boolean bl) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    CacheViewDialog.this.progressDialog.setIndeterminate(bl);
                }
            }
        });
    }

    public void showLaunchingApplication(final String string) {
        final ProgressDialog progressDialog = this.progressDialog;
        if (progressDialog != null) {
            this.invokeLater(new Runnable(){

                public void run() {
                    progressDialog.setTitle(string);
                    progressDialog.setMasthead(ResourceManager.getString((String)"progress.launching"), true);
                    progressDialog.showProgress(100);
                }
            });
        }
    }

    public void clearWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearWindowHelper();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        CacheViewDialog.this.clearWindowHelper();
                    }
                });
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
    }

    private void clearWindowHelper() {
        this.reset();
    }

    public void disposeWindow() {
        if (this.progressDialog != null) {
            this.clearWindow();
            this.exitOnCancel = false;
            this.progressDialog.getDialog().removeWindowListener(this);
            this.setVisible(false);
            this.progressDialog = null;
        }
    }

    public void reset() {
        final ProgressDialog progressDialog = this.progressDialog;
        if (progressDialog != null) {
            this.stopTimer();
            this.invokeLater(new Runnable(){

                public void run() {
                    progressDialog.setMasthead("", true);
                    progressDialog.showProgress(9999);
                    progressDialog.setProgressStatusText(null);
                }
            });
        }
    }

    public void setTitle(final String string) {
        this.invokeLater(new Runnable(){

            public void run() {
                if (CacheViewDialog.this.progressDialog != null) {
                    CacheViewDialog.this.progressDialog.setTitle(string);
                }
            }
        });
    }

    private void showDownloadWindow() {
        if (this.allowVisible && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void progress(URL uRL, String string, long l, long l2, int n) {
        this.showDownloadWindow();
        this.timerOn = true;
        this.percentComplete = n;
        if (uRL != this.currentUrl && uRL != null) {
            this.setHeadingLater(ResourceManager.getString((String)"progress.downloading"));
            this.currentUrl = uRL;
        }
        this.percentComplete = n;
        if (this.progressDialog != null) {
            if (l2 == -1L) {
                this.progressDialog.showProgress(9999);
            } else {
                this.progressDialog.showProgress(n);
            }
        }
    }

    public void upgradingArchive(URL uRL, String string, int n, int n2) {
        this.showDownloadWindow();
        if (this.currentUrl != uRL || n == 0) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString((String)"progress.patching"));
            }
            this.currentUrl = uRL;
        }
    }

    public void validating(URL uRL, String string, long l, long l2, int n) {
        this.showDownloadWindow();
        if (this.currentUrl != uRL || l == 0L) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString((String)"progress.verifying"));
            }
            this.currentUrl = uRL;
        }
    }

    public void downloadFailed(URL uRL, String string) {
        this.stopTimer();
        this.setHeading(ResourceManager.getString((String)"progress.download.failed"), true);
        if (this.progressDialog != null) {
            this.progressDialog.showProgress(9999);
        }
    }

    public void extensionDownload(String string, int n) {
    }

    public void jreDownload(String string, URL uRL) {
        this.setHeading(ResourceManager.getString((String)"progress.download.jre", (String)string), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
        if (!this.timerOn || this.percentComplete <= 0) {
            return;
        }
        ++this.timerCount;
        int n = this.timerCount * 1500;
        int n2 = this.percentComplete - this.timerLastPercent;
        this.timerLastPercent = this.percentComplete;
        this.timerDownloadPercents[this.timerCount % 10] = n2;
        if (n > 8000) {
            int n3;
            int n4 = 0;
            int n5 = Math.min(10, this.timerCount);
            for (n3 = 0; n3 < n5; ++n3) {
                n4 += this.timerDownloadPercents[n3];
            }
            if (this.percentComplete == 100) {
                this.setEstimatedTime("");
            } else if (n4 != 0 && this.percentComplete > 0) {
                String string;
                n3 = n / 1000 * (100 - this.percentComplete) / this.percentComplete;
                int n6 = n3 / 60;
                int n7 = n3 - n6 * 60;
                if (n6 > 0) {
                    String string2 = n6 == 1 ? (n7 == 1 ? "progress.time.left.minute.second" : "progress.time.left.minute.seconds") : (n7 == 1 ? "progress.time.left.minutes.second" : "progress.time.left.minutes.seconds");
                    string = ResourceManager.getString((String)string2, (String)("" + n6), (String)("" + n7));
                } else {
                    String string3 = n7 == 1 ? "progress.time.left.second" : "progress.time.left.seconds";
                    string = ResourceManager.getString((String)string3, (String)("" + n7));
                }
                this.setEstimatedTime(string);
            }
        }
    }

    private void stopTimer() {
        this.timerOn = false;
        if (this.timerObject != null) {
            this.timerObject.stop();
        }
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancelAction();
        this.resetCancled();
    }

    private void cancelAction() {
        this.isVisible = false;
        if (this.exitOnCancel) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CacheViewDialog.systemExit(-1);
                    }
                    catch (Exception exception) {
                        Trace.println((String)("systemExit: " + exception), (TraceLevel)TraceLevel.BASIC);
                        Trace.ignoredException((Exception)exception);
                    }
                    return null;
                }
            });
        } else {
            this.isCanceled = true;
        }
    }

    private static void systemExit(int n) throws Exception {
        Trace.flush();
        if (Environment.isJavaPlugin()) {
            RuntimeException runtimeException = new RuntimeException("exit(" + n + ")");
            throw runtimeException;
        }
        System.exit(n);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void resetCancled() {
        this.isCanceled = false;
    }

    public void setAllowVisible(boolean bl) {
        this.allowVisible = bl;
    }

    public void setVisible(final boolean bl) {
        final ProgressDialog progressDialog = this.progressDialog;
        if (!bl) {
            this.exitOnCancel = false;
            this.stopTimer();
        }
        if (progressDialog != null && bl != this.isVisible) {
            this.isVisible = bl;
            this.invokeLater(new Runnable(){

                public void run() {
                    if (bl) {
                        UIFactory.showProgressDialog((ProgressDialog)progressDialog);
                        CacheViewDialog.this.answer = progressDialog.getUserAnswer();
                        if (CacheViewDialog.this.answer == 1) {
                            CacheViewDialog.this.cancelAction();
                        }
                    } else {
                        UIFactory.hideProgressDialog((ProgressDialog)progressDialog);
                    }
                }
            });
        } else if (progressDialog != null && !bl) {
            UIFactory.hideProgressDialog((ProgressDialog)progressDialog);
        }
    }

    public boolean isVisible() {
        return this.progressDialog != null && this.isVisible;
    }

    public void setApplication(String string, String string2, String string3) {
        this.progressDialog.setApplication(string, string2, string3);
    }

    public int showConfirmDialog(AppInfo appInfo, String string, String string2) {
        this.initialize(null, appInfo, false, true, true);
        this.progressDialog.setMasthead(string, false);
        this.setVisible(true);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.isVisible());
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.progressDialog.getUserAnswer() == -1 && this.isVisible());
        if (this.isVisible()) {
            this.initialize(null, appInfo, true, false, true);
        }
        return this.progressDialog.getUserAnswer();
    }

    private void invokeLater(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            DeploySysRun.execute((DeploySysAction)new DeploySysAction(){

                public Object execute() {
                    SwingUtilities.invokeLater(runnable);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
    }
}

