/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.resourcescreator.utils;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class NewProjectHelper {
    public static IProject createProject(String projectName, URI location) {
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        IProject project = NewProjectHelper.createBaseProject(projectName, location);
        return project;
    }

    public static IProject createApplicationProject(String projectName) {
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        IProject project = NewProjectHelper.createBaseProject(projectName, null);
        try {
            NewProjectHelper.addApplicationNature(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            project = null;
        }
        return project;
    }

    private static IProject createBaseProject(String projectName, URI location) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    private static void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            NewProjectHelper.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
    }

    public static void addFolderToProject(IProject newProject, String folder) throws CoreException {
        IFolder etcFolders = newProject.getFolder(folder);
        NewProjectHelper.createFolder(etcFolders);
    }

    private static void addApplicationNature(IProject project) throws CoreException {
        if (!project.hasNature("it.sogei.rcp.resourcescreator.application")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "it.sogei.rcp.resourcescreator.application";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    public static void addNatureToProject(IProject project, String natureId) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }
}

