/*
 * Decompiled with CFR 0.152.
 */
package sogei.V9TJU000.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import sogei.V9TJU000.utility.HashCodeManagerXML;

public class ReadXMLFileSAXProperties {
    private static final String PROPERTIES_KEY_CICLO = "Ciclo";
    private static final String PROPERTIES_KEY_IDENTIFICATIVO = "Identificativo";
    private static final String PROPERTIES_KEY_CODICEFISCALE = "1CodiceFiscale";
    private static final String PROPERTIES_KEY_CODICEFISCALE_RAPPRESENTANTE = "2CodiceCaricaRappresentante";
    private static final String PROPERTIES_KEY_CODICECARICA_RAPPRESENTANTE = "3CodiceFiscaleRappresentante";
    private static final String propertiesFile = "xml.properties";
    private Properties properties;
    private Map fieldsMap = new HashMap();
    private Map cicliMap = new HashMap();
    private Map identificativiMap = new HashMap();
    private Map codfiscMap = new HashMap();
    private Map codfiscRappMap = new HashMap();
    private Map codcaricaRappMap = new HashMap();
    private static ReadXMLFileSAXProperties instance;

    public static void main(String[] args) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, JDOMException, JAXBException {
        String f = args[0];
        File file = new File(f);
        if (file.exists()) {
            new HashCodeManagerXML(f, 0, 0, "123456", "03012013");
        } else {
            System.out.println(file + " non esiste");
        }
    }

    private String getValoreElemento(Element root, String path) {
        List branches = this.formatList(path);
        String identificativo = null;
        Element cursor = null;
        if (branches != null) {
            int i = 0;
            while (i < branches.size()) {
                String branch = (String)branches.get(i);
                if (!root.getName().equalsIgnoreCase(branch)) {
                    List<Element> elements = null;
                    elements = cursor == null ? this.getElements(root, branch) : this.getElements(cursor, branch);
                    if (elements.size() != 0) {
                        if (i == branches.size() - 1) {
                            identificativo = elements.get(0).getValue();
                        } else {
                            cursor = elements.get(0);
                        }
                    }
                }
                ++i;
            }
        } else {
            return null;
        }
        return identificativo;
    }

    private List<Element> getCicloElements(Element root, String codiceFornitura) {
        List branches = this.formatList((String)this.cicliMap.get(codiceFornitura));
        ArrayList<Element> cicli = new ArrayList<Element>();
        Element cursor = null;
        int i = 0;
        while (i < branches.size()) {
            String branch = (String)branches.get(i);
            if (!root.getName().equalsIgnoreCase(branch)) {
                List<Element> elements = null;
                elements = cursor == null ? this.getElements(root, branch) : this.getElements(cursor, branch);
                if (i == branches.size() - 1) {
                    int x = 0;
                    while (x < elements.size()) {
                        cicli.add(elements.get(x));
                        ++x;
                    }
                } else {
                    cursor = elements.get(0);
                }
            }
            ++i;
        }
        return cicli;
    }

    private List<Element> getElements(Element root, String elementName) {
        List children = root.getChildren();
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < children.size()) {
            Element child = (Element)children.get(i);
            if (child.getName().equalsIgnoreCase(elementName)) {
                elements.add(child);
            }
            ++i;
        }
        return elements;
    }

    public static synchronized ReadXMLFileSAXProperties getInstance() {
        if (instance == null) {
            instance = new ReadXMLFileSAXProperties();
        }
        return instance;
    }

    private ReadXMLFileSAXProperties() {
        this.readFile();
    }

    public List getFields(String codiceFornitura) {
        return (List)this.fieldsMap.get(codiceFornitura);
    }

    private List tokenize(String field) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (field != null) {
            StringTokenizer tokenizer = new StringTokenizer(field, "/");
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
        }
        return tokens;
    }

    private void readFile() {
        this.properties = new Properties();
        InputStream is = null;
        try {
            File f = new File(propertiesFile);
            is = new FileInputStream(f);
        }
        catch (Exception e) {
            is = null;
            e.printStackTrace();
        }
        try {
            if (is == null) {
                is = ReadXMLFileSAXProperties.class.getClassLoader().getResourceAsStream("/it/sogei/telematico/xml/properties/xml.properties");
            }
            this.properties.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.properties != null) {
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (this.properties.getProperty(key) == null || this.properties.getProperty(key).length() <= 0) continue;
                String code = key.substring(0, key.indexOf(46));
                String field = key.substring(key.indexOf(46) + 1);
                ArrayList<String> fields = (ArrayList<String>)this.fieldsMap.get(code);
                if (fields == null) {
                    fields = new ArrayList<String>();
                }
                if (PROPERTIES_KEY_CICLO.equals(field)) {
                    this.cicliMap.put(code, this.properties.getProperty(key));
                    continue;
                }
                if (PROPERTIES_KEY_IDENTIFICATIVO.equals(field)) {
                    this.identificativiMap.put(code, this.properties.getProperty(key));
                    fields.add(this.properties.getProperty(key));
                    continue;
                }
                if (PROPERTIES_KEY_CODICEFISCALE.equals(field)) {
                    this.codfiscMap.put(code, this.properties.getProperty(key));
                    this.fieldsMap.put(code, fields);
                    fields.add(this.properties.getProperty(key));
                    continue;
                }
                if (PROPERTIES_KEY_CODICECARICA_RAPPRESENTANTE.equals(field)) {
                    this.codcaricaRappMap.put(code, this.properties.getProperty(key));
                    this.fieldsMap.put(code, fields);
                    fields.add(this.properties.getProperty(key));
                    continue;
                }
                if (!PROPERTIES_KEY_CODICEFISCALE_RAPPRESENTANTE.equals(field)) continue;
                this.codfiscRappMap.put(code, this.properties.getProperty(key));
                this.fieldsMap.put(code, fields);
                fields.add(this.properties.getProperty(key));
            }
        }
    }

    private String formatField(String field) {
        List t = this.tokenize(field);
        if (t != null && t.size() > 0) {
            return (String)t.get(t.size() - 1);
        }
        return null;
    }

    private List formatList(String field) {
        List t = this.tokenize(field);
        if (t != null && t.size() > 0) {
            return t;
        }
        return null;
    }

    public List getData(File file, String codiceFornitura) throws ParserConfigurationException, SAXException, IOException, JDOMException, XPathExpressionException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        return this.getData(document, codiceFornitura);
    }

    public List getData(Document doc, String codiceFornitura) throws ParserConfigurationException, SAXException, IOException, JDOMException, XPathExpressionException {
        System.out.println("getData " + codiceFornitura + " - " + this.cicliMap);
        System.out.println("Document: " + doc);
        ArrayList l = new ArrayList();
        Element root = doc.getRootElement();
        List<Element> elements = this.getCicloElements(root, codiceFornitura);
        for (Element element : elements) {
            String identificativo = this.getValoreElemento(element, (String)this.identificativiMap.get(codiceFornitura));
            String codicefiscale = this.getValoreElemento(element, (String)this.codfiscMap.get(codiceFornitura));
            String codicecarica_rapp = "";
            String codicefiscale_rapp = "";
            if (!this.codcaricaRappMap.isEmpty()) {
                codicecarica_rapp = this.getValoreElemento(element, (String)this.codcaricaRappMap.get(codiceFornitura));
            }
            if (!this.codfiscRappMap.isEmpty()) {
                codicefiscale_rapp = this.getValoreElemento(element, (String)this.codfiscRappMap.get(codiceFornitura));
            }
            System.out.println("identificativo: " + identificativo);
            List cfr_ignored_0 = (List)this.fieldsMap.get(codiceFornitura);
            ArrayList<String> valori = new ArrayList<String>();
            valori.add(identificativo);
            valori.add(codicefiscale);
            valori.add(codicecarica_rapp);
            valori.add(codicefiscale_rapp);
            l.add(valori);
        }
        return l;
    }
}

