package RISCOS::MemMap;

require Exporter;
use strict;
use vars qw (@ISA @EXPORT $VERSION @page_status);

@ISA = qw(Exporter);
@EXPORT_OK = 'page_status';
$VERSION = 0.02;
# Version 0.02 uses map

@page_status = (
     'Read/Write',
     'Read Only',
     'Inaccessible',
     'Mapped out'
);

sub page_status {
    return $page_status[$_[0]] unless wantarray;
    map  { $page_status[$_] } @_;
}

1;
__END__

=head1 NAME

RISCOS::MemMap --perl module to manage memory map entries

=head1 SYNOPSIS

    use RISCOS::MemMap 'page_status';
    $status_text = page_status $status;

=head1 DESCRIPTION

This module provides a perl function C<page_status> to convert numeric OS MemMap
page access flags to text. If called in scalar context C<page_status> will
return the text corresponding to the first argument. In array context it will
return a list of text lines correspoding to the arguments,

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>

=cut
