NAME
    RISCOS::Draw --perl interface to the Draw module

SYNOPSIS
        use RISCOS::Draw qw(what split_path_block path_bbox);
        # Convert join name to number, default to bevelled
        $join = what ('join', 'bevelled', $join);
        # Split scalar containing path into array of path elements
        @path = split_path_block $block;
        $bbox = path_bbox $block, $width;


DESCRIPTION
    `RISCOS::Draw' provides an interface to the Draw module, which
    provides "an implementation of PostScript type drawing". At
    present only functions necessary to calculate path bounding
    boxes have been implemented, principally for use by the DrawFile
    Path object.

  Subroutines

    what <type> <default> <values...>
        `what' converts names of options into the appropriate
        numeric constants. Arguments passed as numbers are faulted
        if they do not correspond to a named option. *type* can
        either be a reference to a typeglob (which supplies a hash
        to convert from name to number and an array from number to
        name) or a string to use lookup tables provided by this
        package. `RISCOS::Draw' provides these tables:

        	non-zero		0
        	negative		1
        	even-odd		2
        	positive		3

        	non-boundary exterior	4
        	boundary exterior	8
        	boundary interior	16
        	non-boundary interior	32

        	butt			0
        	round			1
        	square			2
        	triangle		3

        	mitred			0
        	round			1
        	bevelled		2

        	end			0
        	continue		1
        	move			2
        	move_same_wind		3
        	close_gap		4
        	close			5
        	bezier			6
        	gap_same_sub		7
        	line			8


        *default* is a default value (string or text) to use for any
        undefined values passed as arguments. Numeric defaults are
        deliberately not checked for validity. In array context
        `what' returns an array corresponding to the converted
        arguments. In scalar context `what' returns only the first
        value.

    unwhat <type> <default> <values...>
        `unwhat' provides the reverse conversion to `what',
        converting numeric values to text. Any undefined values are
        converted to the (unchecked) supplied default.In scalar
        context it returns the first conversion only, in array
        context a list of conversions.

    split_dash_block <block>
        Splits a dash block into an array of integers, which should
        be regarded as a single value followed by a list. The first
        value is the offset of the start of the dash pattern in the
        list. The list itself gives the length of dash segments in
        user units.

    pack_dash_block <packed_block>

    pack_dash_block <array_ref>

    pack_dash_block <start> <array_ref>
        Packs an array of integers into a block to pass to `Draw'
        SWIs or to store in a DrawFile. If a single array reference
        is passed it is assumed to point to an array `($start,
        @lengths)' (which is passed to shift). If two arguments are
        passed the first is taken to be the start index, the second
        a reference to an array of dash lengths. If a single scalar
        is passed it is assumed to be already packed and is returned
        verbatim.

    split_path_block <path_block>
        splits the scalar containing a series of `Draw' path
        elements into an array, with each element containing the a
        single move, line or curve. Concatenating the array with
        `join ''' will give the original scalar, except that the
        terminating end-of-path marker `"\0\0\0\0"' (and any
        trailing garbage) will be absent. If passed a reference to
        an array, then this array (or a reference to it) is
        returned.

        In array context returns this array, in scalar context
        returns a reference to it.

    pack_path_block <reference>

    pack_path_block path elements...
        packs the path block supplied. In scalar context returns the
        path block, in array context returns the path block as if
        split by `split_path_block'.

        If the first argument is scalar reference it is assumed to
        point to an already packed path block and `split_path_block'
        is called if necessary.

        If the first argument is an array reference, it is
        dereferenced and replaces the argument list, else the
        supplied argument list is processed.

        For each entry in turn, if it is an array reference it is
        assumed to point to an array of integer values to be used as
        path/move type and co-ordinates, which are `pack'ed with the
        template `'I*'' and added to the output array. Otherwise the
        entry is assumed to be already packed and added to the
        output array verbatim.

        A final `"\0\0\0\0"' is added to the output list if
        necessary.

        In array context the output array is returned, in scalar
        context it is concatenated with `join '''.

    path_bbox <path> [<winding> <plot_type> <thickness> <join> <start_cap> <end_cap> <dash> <flatness> <transform>
        calculates the bounding box of *path*, returning a reference
        to an array in scalar context, or the array itself in array
        context. `undef' or an empty list are returned if an error
        occurs (including supplying an empty path). All arguments
        except *path* are optional, and will default to sane values
        if not supplied.

        *path* is either a scalar if it is already packed as a
        block, or a reference to be passed to `pack_path_block'.

        *winding* defaults to 0 (non-zero), and is one of the four
        values in the `Draw' winding table (distinct from the two
        used by `DrawFile').

        *plot* is the plot type to pass to the SWI, and defaults to
        'boundary'.

        *thickness* is the line thickness in user units, which
        defaults to 0 (thin)

        *join* is either a scalar to lookup in the join table
        (default bevelled, mitre limit defaults to 10), or a scalar
        reference to select mitred joins with this as the mitre
        limit.

        *start_cap* and *end_cap* are each either scalars to lookup
        in the cap table (default butt, triangle is width  1,
        length  2) or an array ref to select triangle caps with
        `[width, length]'.

        *dash* is either a scalar to be used verbatim as the dash
        block, or an array reference of the form `[$Offset,
        @Values]' to pass to `pack_dash_block'. The default is
        continuous lines.

        *flatness* defaults to 0, which is normally appropriate

        *transform* is a reference to the transformation matrix to
        use, defaulting to none


BUGS
    Definitely not tested enough yet. Some bits not tested at all, I
    believe. Bounding box calculations and sufficient
    packing/unpacking to manipulate DrawFiles does work.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

