NAME
    RISCOS::AOF -- manipulate ARM Object Format files

SYNOPSIS
        use RISCOS::AOF;

        my $obj_file = new RISCOS::AOF $file;
        foreach my $symbol (@{$obj_file->Symbols}) {
    	print $symbol->Name(), "\n" if $symbol->Scope eq 'extern';
        }


DESCRIPTION
    `RISCOS::AOF' provides a class derived from `RISCOS::Chunkfile'
    to manipulate the contents of ARM Oject Format files. It
    provides a class `RISCOS::AOF::Symbol' to store details of each
    symbol in an `AOF' file.

    Currently the implementation is incomplete - only methods to
    manipulate the symbol table have been written. Methods to
    manipulate area data are currently unimplemented.

  Methods

    new <array_ref>

    new <file>
        If passed a reference to an array it is assumed to be an
        array of `RISCOS::Chunk' objects to use as the file
        contents. Otherwise calls `RISCOS::File::load' to loads the
        file specified using and checks that it is `AOF'. Hence
        *file* can be a filename, a reference to a filehandle, or a
        reference to a scalar which is used as the file's contents.

        If passed an array reference then this is used internally in
        the object, so should be created with the anonymous array
        constructor `[]' rather than a reference to a named array
        variable (see the "Common Mistakes" entry in the perldsc
        manpage).

        Returns undefined if there was an error, or the file
        contents are corrupt.

    String <offset> [...]
        Looks up strings in the stringtable.

        In scalar context returns the string at the first offset
        given. In array context returns the list of strings referred
        to by the supplied list of offsets.

    Creator
        Returns whatever string is stored in the `OBJ_IDFN' chunk -
        typically a string identifying the creator of the `AOF'
        file.

    Version
        Returns the version number from the `AOF' file.

    Symbols
        Returns a reference to the array of `RISCOS::AOF::Symbol'
        objects describing the symbols in the `AOF' file.


RISCOS::AOF::Symbol
    The `RISCOS::AOF::Symbol' class is used to hold information
    about a symbol in an `AOF' file. The class provides the
    following methods to access this information:

    Name
        Returns the symbol name.

    Value
        Returns the symbol value. If the symbol is absolute then
        this is just a number. Otherwise it is a string of the form
        "`*value* relative to area '*area*''".

    Defined
        Returns true if the symbol is defined in this `AOF' file.
        Returns false if it is defined externally.

    Scope
        Returns the scope of the symbol ('`static'', '`extern'' or
        '').

    Misc
        Returns an array of strings describing other properties of
        the symbol - *e.g.* '`case insensitive'', '`weak'',
        '`strong'', '`common area''.


BUGS
    As noted, methods to manipulate areas are currently
    unimplemented.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

