NAME
    Text::DDF -- package for creating Impression Document
    Description Format

SYNOPSIS
    	use Text::DDF

    	print ddfencode(@text);

    	use Text::DDF qw(ddfencode $strict_7bit);

    	$strict_7bit = 1;
    	ddfencode(@text);

    	$index = new Text::DDF::Style 'Index', qw (index on);
    	print $index->StyleWrap( @text );


DESCRIPTION
    Text::DDF provides subroutines and classes for creating files in
    Impression Document Description Format.

    `Text::DDF::ddfencode' converts the array to `DDF', converting
    all instances of '`{'' to '`{\123}''. If
    `Text::DDF::strict_7bit' is true, it will also convert top-bit-
    set characters to '`{\###}'' notation.

    `Text::DDF::ddfencode' modifies the array passed, and for ease
    of use additionally returns the array that it converted.

  Effects and Styles

    `Text::DDF' provides classes for manipulating effects and styles
    - `Text::DDF::Effect', `Text::DDF::Justify', `Text::DDF::Style'.
    The overloaded interface hides the differences in the DDF syntax
    used to turn styles and effects on and off.

  Common methods

    new <name> ...
        Declare a style/effect with this name.

        	$bold = new Text::DDF::Effect 'bold';
        	$centre = new Text::DDF::Justify 'centre';
        	$normal = new Text::DDF::Style 'Normal', qw(
        	  font Trinity.Medium
        	  fontsize 12pt );


        Arguments after the style name are passed to the `Add'
        method

        	$no_op = new Text::DDF::Effect;


        defines an empty effect

    StyleOn

    StyleOff
        Return the `DDF' instruction to turn the style/effect
        on/off.

    StyleWrap
        Return the `DDF' turn the style/effect on, the verbatim
        text, the DDF to turn the style/effect off. In array context
        returns an array:

        	(
        	 StyleOn(),
        	 @_,
        	 StyleOf()
        	)


        In scalar context this array is concatenated

    Define()
        Returns the `DDF' needed to defined the style/effect.
        Returns an empty string for an effect, so that a mixed array
        of effects and styles can be `Define'd safely.

    Copy <newname>
        Returns a new style/effect clone. (with the same class as
        its parent.)

    Print
        Returns a formatted definition of the style/effect. This is
        mostly of use to the `Define' method.

        In array context effects return an empty array, whereas
        styles return an array of lines.

        In scalar context styles return text of the form:

        	style  "Normal";
        	 font Trinity.Medium;
        	 fontsize 12pt;


        effects return: effect bold;

        NB scalars are terminated by "`\n'"


  Style Methods

    Add Takes pairs of `attribute, value' and adds them to the style
        definition.

        	$verbatim->Add( qw(spacebelow 0pt) );


        You can use `AddTabs' and `AddTabComma' to add tabs, but the
        `Add' method will spot lines of the form

        	Add( 'tabs', 'r18pt 24pt' );


        and call `AddTabsComma'.

    AddTabs
        Takes an array of tabs, and adds them to the style's array
        of tabs.

        Tabs are strings such as

        	r18pt
        	25.4mm
        	c4pi


        The available prefixes are

    l     Left justify tab (the default if no prefix)

    c     Centre justify tab

    r     Right justify tab

    d     Decimal tab

    v     Vertical rule off

        	$itemlist->AddTabs( qw( r18pt 24pt 72pt 144pt 216pt 288pt 360pt 432pt 504pt ) );


    AddTabsComma
        Adds a comma separated list of tabs. Literally:

            sub AddTabsComma {
        	my $self = shift;
        	$self->AddTabs( split (/,/, $_[0]) );
            }


    Get <attribute> ...
        Returns an array of values corresponding to the array of
        attributes passed

    Delete <attribute> ...
        Delete values corresponding to the array of attributes
        passed

    GetTabs
        In array context returns the sorted array of tabs in the
        format

        	right 18pt
        	centre 3pi
        	 25.5mm


        In scalar context joins the list with commas

        	right 18pt,centre 3pi, 25.5mm


    DeleteTabs
        Not implemented yet.

    PrintTabs
        In array context returns the sorted array of tabs in the
        format

        	right 18pt
        	centre 3pi
        	 25.5mm


        In scalar context joins the list with commas and prefixes
        'tabs'

        	tabs right 18pt,centre 3pi, 25.5mm


        or returns '' if there are no tabs defined.


BUGS
  Shortcomings of Impression's DDF interpreter

    *   DDF effects don't nest, whereas styles do.

        	{bold on}Hello {bold on}W{bold}orld!{bold}

        	{"bold" on}Hello {"bold" on}W{"bold"}orld!{"bold"}


        produce

        Hello World!

        Hello World!

        respectively if `"bold"' is a style with the `bold'
        attribute.

    *   Even in Impression 4.11 the DDF exporter can't cope with style
        names containing `"' characters. Text::DDF::Style makes no
        checks about the validity of characters in the style name.

    *   There's no way to `{keepregion}' two adjacent regions.

        	{keepregion on}Pugh, Pugh, Barney McGrew,
        	Cuthbert, Dibble, Grub
        	{keepregion}{keepregion on}Time files by when you're the driver of a train,
        	and you ride on the footplate there and back again
        	{keepregion}


        won't allow a breaks between the two regions.

        	{keepregion on}Pugh, Pugh, Barney McGrew,
        	Cuthbert, Dibble, Grub{keepregion}
        	{keepregion on}Time files by when you're the driver of a train,
        	and you ride on the footplate there and back again
        	{keepregion}


        will allow a break between *Pugh, Pugh, Barney McGrew,* and
        *Cuthbert, Dibble, Grub*.


  Shortcomings of this package

    You can't (yet) merge styles.

    You can't (yet) merge effects into styles. (This would require a
    hash/function to map effect names into style attributes).

AUTHOR
    Nicholas Clark <nick@unfortu.net>

