/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util.jaxb;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.axiom.om.OMAttachmentAccessor;

final class AttachmentUnmarshallerImpl
extends AttachmentUnmarshaller {
    private final OMAttachmentAccessor attachmentAccessor;

    AttachmentUnmarshallerImpl(OMAttachmentAccessor attachmentAccessor) {
        this.attachmentAccessor = attachmentAccessor;
    }

    private static String getContentIDFromURL(String url) {
        if (url.startsWith("cid:")) {
            try {
                return URLDecoder.decode(url.substring(4), "ascii");
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
        }
        throw new IllegalArgumentException("The URL doesn't use the cid scheme");
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        throw new UnsupportedOperationException();
    }

    public DataHandler getAttachmentAsDataHandler(String cid) {
        DataHandler dh = this.attachmentAccessor.getDataHandler(AttachmentUnmarshallerImpl.getContentIDFromURL(cid));
        if (dh == null) {
            throw new IllegalArgumentException("No MIME part found for content ID '" + cid + "'");
        }
        return dh;
    }

    public boolean isXOPPackage() {
        return true;
    }
}

