/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.push.sax;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.common.serializer.push.sax.ContentHandlerWriter;
import org.apache.axiom.om.impl.common.serializer.push.sax.ContentHandlerXMLStreamWriter;
import org.apache.axiom.om.impl.common.serializer.push.sax.SAXExceptionWrapper;
import org.apache.axiom.om.impl.common.serializer.push.sax.SAXHelper;
import org.apache.axiom.om.impl.common.serializer.push.sax.SAXOutputException;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.apache.axiom.util.namespace.ScopedNamespaceContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXSerializer
extends Serializer {
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;
    private final ScopedNamespaceContext nsContext = new ScopedNamespaceContext();
    private boolean startDocumentWritten;
    private boolean autoStartDocument;
    private int depth;
    private final SAXHelper helper = new SAXHelper();

    public SAXSerializer(OMSerializable root, ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        super(root, false, true);
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    protected boolean isAssociated(String prefix, String namespace) throws OutputException {
        return this.nsContext.getNamespaceURI(prefix).equals(namespace);
    }

    private void writeStartDocument() throws OutputException {
        try {
            this.contentHandler.startDocument();
            this.startDocumentWritten = true;
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeStartDocument(String version) throws OutputException {
        this.writeStartDocument();
    }

    public void writeStartDocument(String encoding, String version) throws OutputException {
        this.writeStartDocument();
    }

    public void writeDTD(String rootName, String publicId, String systemId, String internalSubset) throws OutputException {
        if (this.lexicalHandler != null) {
            try {
                this.lexicalHandler.startDTD(rootName, publicId, systemId);
                this.lexicalHandler.endDTD();
            }
            catch (SAXException ex) {
                throw new SAXOutputException(ex);
            }
        }
    }

    protected void beginStartElement(String prefix, String namespaceURI, String localName) throws OutputException {
        if (!this.startDocumentWritten) {
            this.writeStartDocument();
            this.autoStartDocument = true;
        }
        this.helper.beginStartElement(prefix, namespaceURI, localName);
        this.nsContext.startScope();
        ++this.depth;
    }

    protected void addNamespace(String prefix, String namespaceURI) throws OutputException {
        this.nsContext.setPrefix(prefix, namespaceURI);
        try {
            this.contentHandler.startPrefixMapping(prefix, namespaceURI);
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    protected void addAttribute(String prefix, String namespaceURI, String localName, String type, String value) throws OutputException {
        this.helper.addAttribute(prefix, namespaceURI, localName, type, value);
    }

    protected void finishStartElement() throws OutputException {
        try {
            this.helper.finishStartElement(this.contentHandler);
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeEndElement() throws OutputException {
        try {
            this.helper.writeEndElement(this.contentHandler, this.nsContext);
            if (--this.depth == 0 && this.autoStartDocument) {
                this.contentHandler.endDocument();
            }
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeText(int type, String data) throws OutputException {
        char[] ch = data.toCharArray();
        try {
            switch (type) {
                case 4: {
                    this.contentHandler.characters(ch, 0, ch.length);
                    break;
                }
                case 12: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.contentHandler.characters(ch, 0, ch.length);
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.endCDATA();
                    }
                    break;
                }
                case 6: {
                    this.contentHandler.ignorableWhitespace(ch, 0, ch.length);
                }
            }
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeComment(String data) throws OutputException {
        if (this.lexicalHandler != null) {
            char[] ch = data.toCharArray();
            try {
                this.lexicalHandler.comment(ch, 0, ch.length);
            }
            catch (SAXException ex) {
                throw new SAXOutputException(ex);
            }
        }
    }

    public void writeProcessingInstruction(String target, String data) throws OutputException {
        try {
            this.contentHandler.processingInstruction(target, data);
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeEntityRef(String name) throws OutputException {
        try {
            this.contentHandler.skippedEntity(name);
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }

    public void writeDataHandler(DataHandler dataHandler, String contentID, boolean optimize) throws OutputException {
        Base64EncodingWriterOutputStream out = new Base64EncodingWriterOutputStream(new ContentHandlerWriter(this.contentHandler), 4096, true);
        try {
            dataHandler.writeTo((OutputStream)out);
            out.complete();
        }
        catch (IOException ex) {
            Throwable cause = ex.getCause();
            SAXException saxException = cause instanceof SAXException ? (SAXException)cause : new SAXException(ex);
            throw new SAXOutputException(saxException);
        }
    }

    public void writeDataHandler(DataHandlerProvider dataHandlerProvider, String contentID, boolean optimize) throws OutputException {
        throw new UnsupportedOperationException();
    }

    protected void serializePushOMDataSource(OMDataSource dataSource) throws OutputException {
        try {
            ContentHandlerXMLStreamWriter writer = new ContentHandlerXMLStreamWriter(this.helper, this.contentHandler, this.lexicalHandler, this.nsContext);
            if (this.startDocumentWritten) {
                dataSource.serialize(writer);
            } else {
                this.contentHandler.startDocument();
                dataSource.serialize(writer);
                this.contentHandler.endDocument();
            }
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
        catch (SAXExceptionWrapper ex) {
            throw new SAXOutputException((SAXException)ex.getCause());
        }
        catch (XMLStreamException ex) {
            throw new SAXOutputException(new SAXException(ex));
        }
    }

    public void writeEndDocument() throws OutputException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException ex) {
            throw new SAXOutputException(ex);
        }
    }
}

