/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.HtmlSpecialTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class AbstractMarkupFilter
implements IMarkupFilter {
    private final MarkupResourceStream markupResourceStream;
    private IMarkupFilter parent;
    protected static final MetaDataKey<Map<String, AtomicInteger>> REQUEST_COUNTER_KEY = new MetaDataKey<Map<String, AtomicInteger>>(){
        private static final long serialVersionUID = 1L;
    };

    public AbstractMarkupFilter() {
        this(null);
    }

    public AbstractMarkupFilter(MarkupResourceStream markupResourceStream) {
        this.markupResourceStream = markupResourceStream;
    }

    @Override
    public IMarkupFilter getNextFilter() {
        return this.parent;
    }

    @Override
    public void setNextFilter(IMarkupFilter parent) {
        this.parent = parent;
    }

    @Override
    public MarkupElement nextElement() throws ParseException {
        MarkupElement elem = this.getNextFilter().nextElement();
        if (elem != null) {
            if (elem instanceof ComponentTag) {
                elem = this.onComponentTag((ComponentTag)elem);
            } else if (elem instanceof HtmlSpecialTag) {
                elem = this.onSpecialTag((HtmlSpecialTag)elem);
            }
        }
        return elem;
    }

    protected abstract MarkupElement onComponentTag(ComponentTag var1) throws ParseException;

    protected MarkupElement onSpecialTag(HtmlSpecialTag tag) throws ParseException {
        return tag;
    }

    @Override
    public void postProcess(Markup markup) {
    }

    protected MarkupResourceStream getMarkupResourceStream() {
        return this.markupResourceStream;
    }

    protected String getWicketNamespace() {
        return this.getWicketNamespace(null);
    }

    protected String getWicketNamespace(MarkupStream markupStream) {
        String wicketNamespace = "wicket";
        if (markupStream != null) {
            wicketNamespace = markupStream.getWicketNamespace();
        } else if (this.markupResourceStream != null) {
            wicketNamespace = this.markupResourceStream.getWicketNamespace();
        }
        return wicketNamespace;
    }

    protected int getRequestUniqueId() {
        AtomicInteger counter;
        String cacheKey;
        RequestCycle requestCycle = RequestCycle.get();
        Map<String, AtomicInteger> markupUniqueCounters = requestCycle.getMetaData(REQUEST_COUNTER_KEY);
        ContainerInfo containerInfo = this.getMarkupResourceStream().getContainerInfo();
        String string = cacheKey = containerInfo != null ? containerInfo.getContainerClass().getCanonicalName() : null;
        if (markupUniqueCounters == null) {
            markupUniqueCounters = new HashMap<String, AtomicInteger>();
            requestCycle.setMetaData((MetaDataKey)REQUEST_COUNTER_KEY, markupUniqueCounters);
        }
        if ((counter = markupUniqueCounters.get(cacheKey)) == null) {
            counter = new AtomicInteger();
            markupUniqueCounters.put(cacheKey, counter);
        }
        int cacheHash = cacheKey == null ? 0 : cacheKey.hashCode();
        return cacheHash * 31 + counter.getAndIncrement();
    }
}

