/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.ArrayList;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.TrackingResultProcessor;
import org.elasticsearch.threadpool.ThreadPool;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    SimulateDocumentResult executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose) {
        if (verbose) {
            ArrayList<SimulateProcessorResult> processorResultList = new ArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), processorResultList);
            try {
                Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                ingestDocument.executePipeline(verbosePipeline);
                return new SimulateDocumentVerboseResult(processorResultList);
            }
            catch (Exception e) {
                return new SimulateDocumentVerboseResult(processorResultList);
            }
        }
        try {
            IngestDocument result = pipeline.execute(ingestDocument);
            return new SimulateDocumentBaseResult(result);
        }
        catch (Exception e) {
            return new SimulateDocumentBaseResult(e);
        }
    }

    public void execute(SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute(ActionRunnable.wrap(listener, l -> {
            ArrayList<SimulateDocumentResult> responses = new ArrayList<SimulateDocumentResult>();
            for (IngestDocument ingestDocument : request.getDocuments()) {
                SimulateDocumentResult response = this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose());
                if (response == null) continue;
                responses.add(response);
            }
            l.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
        }));
    }
}

