/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.InstantList;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.Names;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public class MovingFeatures {
    public static final DefaultAttributeType<Instant> TIME_AS_INSTANTS;
    private static final DefaultAttributeType<Number> TIME_AS_NUMBERS;
    private final Map<Vector, InstantList> cache;

    public static DefaultAttributeType<?> characteristic(boolean hasCRS) {
        return hasCRS ? TIME_AS_INSTANTS : TIME_AS_NUMBERS;
    }

    public MovingFeatures(MovingFeatures share) {
        this.cache = share != null ? share.cache : new HashMap<Vector, InstantList>();
    }

    public final void setInstants(AbstractAttribute<?> dest, long[] millis) {
        AbstractAttribute<Instant> c = TIME_AS_INSTANTS.newInstance();
        c.setValues(this.cache.computeIfAbsent(InstantList.vectorize(millis), InstantList::new));
        dest.characteristics().values().add(c);
    }

    public static void setTimes(AbstractAttribute<?> dest, Vector values, DefaultTemporalCRS converter) {
        AbstractAttribute<Serializable> ct;
        if (converter != null) {
            Instant[] instants = new Instant[values.size()];
            for (int i = 0; i < instants.length; ++i) {
                instants[i] = converter.toInstant(values.doubleValue(i));
            }
            AbstractAttribute<Instant> c = TIME_AS_INSTANTS.newInstance();
            c.setValues(UnmodifiableArrayList.wrap(instants));
            ct = c;
        } else {
            AbstractAttribute<Number> c = TIME_AS_NUMBERS.newInstance();
            c.setValues(values);
            ct = c;
        }
        dest.characteristics().values().add(ct);
    }

    static {
        LocalName scope = Names.createLocalName("OGC", null, "MF");
        Map<String, ScopedName> properties = Map.of("name", Names.createScopedName(scope, null, "datetimes"));
        TIME_AS_INSTANTS = new DefaultAttributeType<Object>(properties, Instant.class, 0, Integer.MAX_VALUE, null, new DefaultAttributeType[0]);
        TIME_AS_NUMBERS = new DefaultAttributeType<Object>(properties, Number.class, 0, Integer.MAX_VALUE, null, new DefaultAttributeType[0]);
    }
}

