/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.thrift.TBase;
import org.apache.storm.topology.IComponent;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.trident.util.IndexedEdge;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class TridentUtils {
    public static Fields fieldsUnion(Fields ... fields) {
        HashSet<String> ret = new HashSet<String>();
        for (Fields f : fields) {
            if (f == null) continue;
            ret.addAll(f.toList());
        }
        return new Fields(new ArrayList<String>(ret));
    }

    public static Fields fieldsConcat(Fields ... fields) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Fields f : fields) {
            if (f == null) continue;
            ret.addAll(f.toList());
        }
        return new Fields(ret);
    }

    public static Fields fieldsSubtract(Fields all, Fields minus) {
        HashSet<String> removeSet = new HashSet<String>(minus.toList());
        ArrayList<String> toKeep = new ArrayList<String>();
        for (String s : all.toList()) {
            if (removeSet.contains(s)) continue;
            toKeep.add(s);
        }
        return new Fields(toKeep);
    }

    public static Fields getSingleOutputStreamFields(IComponent component) {
        OutputFieldsGetter getter = new OutputFieldsGetter();
        component.declareOutputFields(getter);
        Map<String, StreamInfo> declaration = getter.getFieldsDeclaration();
        if (declaration.size() != 1) {
            throw new RuntimeException("Trident only supports components that emit a single stream");
        }
        StreamInfo si = declaration.values().iterator().next();
        if (si.is_direct()) {
            throw new RuntimeException("Trident does not support direct streams");
        }
        return new Fields(si.get_output_fields());
    }

    public static <T> List<T> getParents(DirectedGraph g, T n) {
        ArrayList incoming = new ArrayList(g.incomingEdgesOf(n));
        Collections.sort(incoming);
        ArrayList ret = new ArrayList();
        for (IndexedEdge e : incoming) {
            ret.add(e.source);
        }
        return ret;
    }

    public static <T> List<T> getChildren(DirectedGraph g, T n) {
        ArrayList outgoing = new ArrayList(g.outgoingEdgesOf(n));
        ArrayList ret = new ArrayList();
        for (IndexedEdge e : outgoing) {
            ret.add(e.target);
        }
        return ret;
    }

    public static <T> T getParent(DirectedGraph g, T n) {
        List<T> parents = TridentUtils.getParents(g, n);
        if (parents.size() != 1) {
            throw new RuntimeException("Expected a single parent");
        }
        return parents.get(0);
    }

    public static byte[] thriftSerialize(TBase t) {
        return Utils.thriftSerialize(t);
    }

    public static <T> T thriftDeserialize(Class<T> c, byte[] b) {
        return Utils.thriftDeserialize(c, b);
    }
}

