/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedMethodsFilter
implements Filter {
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    public static final Set<String> DEFAULT_ALLOWED_METHODS = Set.of("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH");
    private static final Logger LOG = LoggerFactory.getLogger(AllowedMethodsFilter.class);
    private Set<String> allowedMethods = Collections.emptySet();

    public void init(FilterConfig config) {
        this.allowedMethods = Optional.ofNullable(config.getInitParameter(ALLOWED_METHODS_PARAM)).map(p -> Set.of(p.split(","))).orElse(DEFAULT_ALLOWED_METHODS);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.allowedMethods.contains(request.getMethod())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            LOG.debug("Request with disallowed method {} blocked", (Object)request.getMethod());
            response.sendError(405);
        }
    }
}

