/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.PluginMetrics;
import org.apache.kafka.common.metrics.Sensor;

public class PluginMetricsImpl
implements PluginMetrics,
Closeable {
    private static final String GROUP = "plugins";
    private final Metrics metrics;
    private final Map<String, String> tags;
    private final Set<MetricName> metricNames = ConcurrentHashMap.newKeySet();
    private final Set<String> sensors = ConcurrentHashMap.newKeySet();
    private volatile boolean closing = false;

    public PluginMetricsImpl(Metrics metrics, Map<String, String> tags) {
        this.metrics = metrics;
        this.tags = tags;
    }

    @Override
    public MetricName metricName(String name, String description, LinkedHashMap<String, String> tags) {
        if (this.closing) {
            throw new IllegalStateException("This PluginMetrics instance is closed");
        }
        for (String tagName : tags.keySet()) {
            if (!this.tags.containsKey(tagName)) continue;
            throw new IllegalArgumentException("Cannot use " + tagName + " as a tag name");
        }
        LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>(this.tags);
        metricsTags.putAll(tags);
        return this.metrics.metricName(name, GROUP, description, metricsTags);
    }

    @Override
    public void addMetric(MetricName metricName, MetricValueProvider<?> metricValueProvider) {
        if (this.closing) {
            throw new IllegalStateException("This PluginMetrics instance is closed");
        }
        if (this.metricNames.contains(metricName)) {
            throw new IllegalArgumentException("Metric " + String.valueOf(metricName) + " already exists");
        }
        this.metrics.addMetric(metricName, metricValueProvider);
        this.metricNames.add(metricName);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        if (this.closing) {
            throw new IllegalStateException("This PluginMetrics instance is closed");
        }
        if (!this.metricNames.contains(metricName)) {
            throw new IllegalArgumentException("Unknown metric " + String.valueOf(metricName));
        }
        this.metrics.removeMetric(metricName);
        this.metricNames.remove(metricName);
    }

    @Override
    public Sensor addSensor(String name) {
        if (this.closing) {
            throw new IllegalStateException("This PluginMetrics instance is closed");
        }
        if (this.sensors.contains(name)) {
            throw new IllegalArgumentException("Sensor " + name + " already exists");
        }
        Sensor sensor = this.metrics.sensor(name);
        this.sensors.add(name);
        return sensor;
    }

    @Override
    public void removeSensor(String name) {
        if (this.closing) {
            throw new IllegalStateException("This PluginMetrics instance is closed");
        }
        if (!this.sensors.contains(name)) {
            throw new IllegalArgumentException("Unknown sensor " + name);
        }
        this.metrics.removeSensor(name);
        this.sensors.remove(name);
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        for (String sensor : this.sensors) {
            this.metrics.removeSensor(sensor);
        }
        for (MetricName metricName : this.metricNames) {
            this.metrics.removeMetric(metricName);
        }
    }
}

