/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestLog {
    public static final Logger LOG = LoggerFactory.getLogger(HttpRequestLog.class);
    private static final Map<String, String> serverToComponent;

    public static RequestLog getRequestLog(String name) {
        String lookup = serverToComponent.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        Slf4jRequestLogWriter writer = new Slf4jRequestLogWriter();
        writer.setLoggerName(loggerName);
        return new CustomRequestLog((RequestLog.Writer)writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    private HttpRequestLog() {
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cluster", "resourcemanager");
        map.put("hdfs", "namenode");
        map.put("node", "nodemanager");
        serverToComponent = Collections.unmodifiableMap(map);
    }
}

