/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderAutoCommitTest {
    private static String DEST_RES_NAME = "dest";
    private static String MIME_TYPE_JSON = "application/json";
    private static String CLP_CONTENT = "/json-import-samples/content.json";
    private static byte[] MEM_CONTENT = "{\"jcr:primaryType\":\"sling:Folder\"}".getBytes();
    private int destResCount = 1;
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());

    protected abstract ResourceResolverType getResourceResolverType();

    @Test
    public void testJsonAutocommitExplicitly() {
        this.doTestJsonAutocommitExplicitly(false, new HasChangesAssertion());
        this.doTestJsonAutocommitExplicitly(true, new NoChangesAssertion());
    }

    private void doTestJsonAutocommitExplicitly(boolean commit, Runnable assertion) {
        ContentLoader loader = this.context.load(commit);
        Resource a1 = this.context.create().resource(this.nextDestResource());
        loader.json(CLP_CONTENT, a1, "child");
        assertion.run();
        loader.json(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        Resource a3 = this.context.create().resource(this.nextDestResource());
        loader.json((InputStream)data, a3, "child");
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.json((InputStream)data2, this.nextDestResource());
        assertion.run();
    }

    @Test
    public void testJsonAutocommitImplicitly() {
        ContentLoader loader = this.context.load();
        NoChangesAssertion assertion = new NoChangesAssertion();
        Resource r = this.context.create().resource(this.nextDestResource());
        loader.json(CLP_CONTENT, r, "child");
        assertion.run();
        loader.json(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        Resource r2 = this.context.create().resource(this.nextDestResource());
        loader.json((InputStream)data, r2, "child");
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.json((InputStream)data2, this.nextDestResource());
        assertion.run();
    }

    @Test
    public void testBinaryFileAutocommitExplicitly() {
        this.doTestBinaryFileAutocommitExplicitly(false, new HasChangesAssertion());
        this.doTestBinaryFileAutocommitExplicitly(true, new NoChangesAssertion());
    }

    private void doTestBinaryFileAutocommitExplicitly(boolean commit, Runnable assertion) {
        ContentLoader loader = this.context.load(commit);
        loader.binaryFile(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        loader.binaryFile(CLP_CONTENT, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryFile((InputStream)data, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryFile((InputStream)data2, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data3 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r = this.context.create().resource(this.nextDestResource());
        loader.binaryFile((InputStream)data3, r, "child");
        assertion.run();
        ByteArrayInputStream data4 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r2 = this.context.create().resource(this.nextDestResource());
        loader.binaryFile((InputStream)data4, r2, "child", MIME_TYPE_JSON);
        assertion.run();
    }

    @Test
    public void testBinaryFileAutocommitImplicitly() {
        ContentLoader loader = this.context.load();
        NoChangesAssertion assertion = new NoChangesAssertion();
        loader.binaryFile(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        loader.binaryFile(CLP_CONTENT, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryFile((InputStream)data, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryFile((InputStream)data2, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data3 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r = this.context.create().resource(this.nextDestResource());
        loader.binaryFile((InputStream)data3, r, "child");
        assertion.run();
        ByteArrayInputStream data4 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r2 = this.context.create().resource(this.nextDestResource());
        loader.binaryFile((InputStream)data4, r2, "child", MIME_TYPE_JSON);
        assertion.run();
    }

    @Test
    public void testBinaryResourceAutocommitExplicitly() {
        this.doTestBinaryResourceAutocommitExplicitly(false, new HasChangesAssertion());
        this.doTestBinaryResourceAutocommitExplicitly(true, new NoChangesAssertion());
    }

    private void doTestBinaryResourceAutocommitExplicitly(boolean commit, Runnable assertion) {
        ContentLoader loader = this.context.load(commit);
        loader.binaryResource(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        loader.binaryResource(CLP_CONTENT, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryResource((InputStream)data, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryResource((InputStream)data2, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data3 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r = this.context.create().resource(this.nextDestResource());
        loader.binaryResource((InputStream)data3, r, "child");
        assertion.run();
        ByteArrayInputStream data4 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r2 = this.context.create().resource(this.nextDestResource());
        loader.binaryResource((InputStream)data4, r2, "child", MIME_TYPE_JSON);
        assertion.run();
    }

    @Test
    public void testBinaryResourceAutocommitImplicitly() {
        ContentLoader loader = this.context.load();
        NoChangesAssertion assertion = new NoChangesAssertion();
        loader.binaryResource(CLP_CONTENT, this.nextDestResource());
        assertion.run();
        loader.binaryResource(CLP_CONTENT, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryResource((InputStream)data, this.nextDestResource());
        assertion.run();
        ByteArrayInputStream data2 = new ByteArrayInputStream(MEM_CONTENT);
        loader.binaryResource((InputStream)data2, this.nextDestResource(), MIME_TYPE_JSON);
        assertion.run();
        ByteArrayInputStream data3 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r = this.context.create().resource(this.nextDestResource());
        loader.binaryResource((InputStream)data3, r, "child");
        assertion.run();
        ByteArrayInputStream data4 = new ByteArrayInputStream(MEM_CONTENT);
        Resource r2 = this.context.create().resource(this.nextDestResource());
        loader.binaryResource((InputStream)data4, r2, "child", MIME_TYPE_JSON);
        assertion.run();
    }

    private synchronized String nextDestResource() {
        return "/" + DEST_RES_NAME + this.destResCount++;
    }

    private class HasChangesAssertion
    implements Runnable {
        private HasChangesAssertion() {
        }

        @Override
        public void run() {
            Assert.assertTrue((boolean)AbstractContentLoaderAutoCommitTest.this.context.resourceResolver().hasChanges());
        }
    }

    private class NoChangesAssertion
    implements Runnable {
        private NoChangesAssertion() {
        }

        @Override
        public void run() {
            Assert.assertFalse((boolean)AbstractContentLoaderAutoCommitTest.this.context.resourceResolver().hasChanges());
        }
    }
}

