/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.util.EnumSet;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.jackrabbit.api.jmx.QueryStatManagerMBean;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.jmx.RepositoryStatsMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.DefaultStatisticsProvider;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.RepositoryStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.QueryStatImpl;
import org.apache.jackrabbit.stats.TimeSeriesMax;
import org.apache.jackrabbit.stats.jmx.QueryStatManager;

public class StatisticManager {
    private final QueryStatImpl queryStat = new QueryStatImpl();
    private final StatisticsProvider repoStats;
    private final TimeSeriesMax maxQueueLength;
    private final CounterStats maxQueueLengthCounter;
    private final CompositeRegistration registration;
    private static final EnumSet<RepositoryStatistics.Type> NOOP_METRIC_TYPES = EnumSet.of(RepositoryStatistics.Type.SESSION_READ_COUNTER, RepositoryStatistics.Type.SESSION_READ_DURATION, RepositoryStatistics.Type.SESSION_WRITE_DURATION, RepositoryStatistics.Type.QUERY_COUNT);

    public StatisticManager(Whiteboard whiteboard, ScheduledExecutorService executor) {
        this.queryStat.setEnabled(true);
        this.repoStats = this.getStatsProvider(whiteboard, executor);
        this.maxQueueLengthCounter = this.repoStats.getCounterStats("OBSERVATION_QUEUE_MAX_LENGTH", StatsOptions.METRICS_ONLY);
        this.maxQueueLength = new TimeSeriesMax(-1L){

            @Override
            public void recordValue(long value) {
                super.recordValue(value);
                long currentValue = StatisticManager.this.maxQueueLengthCounter.getCount();
                StatisticManager.this.maxQueueLengthCounter.inc(Math.max(value, currentValue) - currentValue);
            }
        };
        this.registration = new CompositeRegistration(WhiteboardUtils.registerMBean(whiteboard, QueryStatManagerMBean.class, new QueryStatManager(this.queryStat), "QueryStat", "Oak Query Statistics"), WhiteboardUtils.registerMBean(whiteboard, RepositoryStatsMBean.class, new RepositoryStats(this.repoStats.getStats(), this.maxQueueLength), "RepositoryStats", "Oak Repository Statistics"), WhiteboardUtils.scheduleWithFixedDelay(whiteboard, new Runnable(){

            @Override
            public void run() {
                StatisticManager.this.maxQueueLength.recordOneSecond();
                StatisticManager.this.maxQueueLengthCounter.dec(StatisticManager.this.maxQueueLengthCounter.getCount() + 1L);
            }
        }, 1L));
    }

    public void logQueryEvaluationTime(String language, String statement, long millis) {
        this.queryStat.logQuery(language, statement, millis);
    }

    public MeterStats getMeter(RepositoryStatistics.Type type) {
        return this.repoStats.getMeter(type.name(), StatisticManager.getOption(type));
    }

    public CounterStats getStatsCounter(RepositoryStatistics.Type type) {
        return this.repoStats.getCounterStats(type.name(), StatisticManager.getOption(type));
    }

    public TimerStats getTimer(RepositoryStatistics.Type type) {
        return this.repoStats.getTimer(type.name(), StatisticManager.getOption(type));
    }

    public TimeSeriesMax maxQueLengthRecorder() {
        return this.maxQueueLength;
    }

    public void dispose() {
        this.registration.unregister();
    }

    private StatisticsProvider getStatsProvider(Whiteboard wb, ScheduledExecutorService executor) {
        StatisticsProvider provider = WhiteboardUtils.getService(wb, StatisticsProvider.class);
        if (provider == null) {
            provider = new DefaultStatisticsProvider(executor);
        }
        return provider;
    }

    private static StatsOptions getOption(RepositoryStatistics.Type type) {
        if (NOOP_METRIC_TYPES.contains((Object)type)) {
            return StatsOptions.TIME_SERIES_ONLY;
        }
        return StatsOptions.DEFAULT;
    }
}

