/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;

public abstract class Clock
extends java.time.Clock {
    private static final int SIMPLE_CLOCK_NOISE = SystemPropertySupplier.create("simple.clock.noise", 0).get();
    private static final long ACCURATE_CLOCK_GRANULARITY = SystemPropertySupplier.create("accurate.clock.granularity", 1L).get();
    static final long FAST_CLOCK_INTERVAL = SystemPropertySupplier.create("fast.clock.interval", 10L).get();
    private long monotonic = 0L;
    private long increasing = 0L;
    public static Clock SIMPLE = Clock.createSimpleClock();
    public static Clock ACCURATE = new Clock(){
        private static final long NS_IN_MS = 1000000L;
        private long ms = SIMPLE.getTime();
        private long ns = System.nanoTime();

        @Override
        public synchronized long getTime() {
            long nowns = System.nanoTime();
            long nsIncrease = Math.max(nowns - this.ns, 0L);
            long msIncrease = (nsIncrease + 500000L) / 1000000L;
            if (ACCURATE_CLOCK_GRANULARITY > 1L) {
                msIncrease -= msIncrease % ACCURATE_CLOCK_GRANULARITY;
            }
            if (msIncrease < 1000L) {
                return this.ms + msIncrease;
            }
            long nowms = SIMPLE.getTime();
            if (msIncrease < 10000L) {
                this.ms += msIncrease;
                this.ns += msIncrease * 1000000L;
                long jump = nowms - this.ms;
                if (jump == 0L) {
                    return this.ms;
                }
                if (0L < jump && jump < 100L) {
                    this.ns -= 100000L;
                    return this.ms;
                }
                if (0L > jump && jump > -100L) {
                    this.ns += 100000L;
                    return this.ms;
                }
            }
            if (nowms >= this.ms + 1000L) {
                this.ms = nowms;
                this.ns = nowns;
            } else {
                this.ms += 1000L;
                this.ns = nowns + (this.ms - nowms) * 1000000L;
            }
            return this.ms;
        }

        public String toString() {
            return "Clock.ACCURATE";
        }
    };

    public abstract long getTime();

    @Override
    public long millis() {
        return this.getTime();
    }

    public synchronized long getTimeMonotonic() {
        long now = this.getTime();
        if (now > this.monotonic) {
            this.monotonic = now;
        } else {
            now = this.monotonic;
        }
        return now;
    }

    public synchronized long getTimeIncreasing() throws InterruptedException {
        long now = this.getTime();
        while (now <= this.increasing) {
            this.wait(0L, 100000);
            now = this.getTime();
        }
        this.increasing = now;
        return now;
    }

    public Date getDate() {
        return new Date(this.getTime());
    }

    public Date getDateMonotonic() {
        return new Date(this.getTimeMonotonic());
    }

    public Date getDateIncreasing() throws InterruptedException {
        return new Date(this.getTimeIncreasing());
    }

    public void waitUntil(long timestamp) throws InterruptedException {
        long now = this.getTimeIncreasing();
        while (now < timestamp) {
            Thread.sleep(timestamp - now);
            now = this.getTimeIncreasing();
        }
    }

    public void waitFor(long delta) throws InterruptedException {
        this.waitUntil(this.getTime() + delta);
    }

    public void waitFor(Duration delta) throws InterruptedException {
        this.waitUntil(this.getTime() + delta.toMillis());
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.of("Z");
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.getTime());
    }

    @Override
    public java.time.Clock withZone(ZoneId zone) {
        if (!zone.equals(ZoneId.of("Z"))) {
            throw new UnsupportedOperationException("ZoneIds other than 'Z' are not supported by this clock");
        }
        return this;
    }

    private static Clock createSimpleClock() {
        final int noise = SIMPLE_CLOCK_NOISE;
        if (noise > 0) {
            return new Clock(){
                private final Random random = new Random();

                @Override
                public synchronized long getTime() {
                    return System.currentTimeMillis() + (long)this.random.nextInt(noise);
                }

                public String toString() {
                    return "Clock.SIMPLE (with noise)";
                }
            };
        }
        return new Clock(){

            @Override
            public long getTime() {
                return System.currentTimeMillis();
            }

            public String toString() {
                return "Clock.SIMPLE";
            }
        };
    }

    public static class Virtual
    extends Clock {
        private final AtomicLong time = new AtomicLong();

        @Override
        public long getTime() {
            return this.time.getAndIncrement();
        }

        @Override
        public void waitUntil(long timestamp) {
            long now = this.time.get();
            while (now < timestamp && !this.time.compareAndSet(now, timestamp)) {
                now = this.time.get();
            }
        }

        public String toString() {
            return "Clock.Virtual";
        }
    }

    public static class Fast
    extends Clock
    implements Closeable {
        private volatile long time = ACCURATE.getTime();
        private final ScheduledFuture<?> future;

        public Fast(ScheduledExecutorService executor) {
            this.future = executor.scheduleAtFixedRate(() -> {
                this.time = ACCURATE.getTime();
            }, FAST_CLOCK_INTERVAL, FAST_CLOCK_INTERVAL, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public String toString() {
            return "Clock.Fast";
        }

        @Override
        public void close() {
            this.future.cancel(false);
        }
    }
}

