/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

final class UserContext
implements Context,
UserConstants {
    private static final Context INSTANCE = new UserContext();

    private UserContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        String propName = property.getName();
        String ntName = TreeUtil.getPrimaryTypeName(parent);
        if ("rep:User".equals(ntName) || "rep:SystemUser".equals(ntName)) {
            return USER_PROPERTY_NAMES.contains(propName);
        }
        if ("rep:Group".equals(ntName)) {
            return GROUP_PROPERTY_NAMES.contains(propName);
        }
        if ("rep:Password".equals(ntName)) {
            return PWD_PROPERTY_NAMES.contains(propName);
        }
        if ("rep:MemberReferences".equals(ntName)) {
            return "rep:members".equals(propName);
        }
        return "rep:Members".equals(ntName);
    }

    @Override
    public boolean definesContextRoot(@NotNull Tree tree) {
        return this.definesTree(tree);
    }

    @Override
    public boolean definesTree(@NotNull Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName(tree);
        return Objects.nonNull(ntName) && NT_NAMES.contains(ntName);
    }

    @Override
    public boolean definesLocation(@NotNull TreeLocation location) {
        Tree tree = location.getTree();
        if (tree != null && location.exists()) {
            PropertyState p = location.getProperty();
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        String path = location.getPath();
        String name = Text.getName(path);
        return USER_PROPERTY_NAMES.contains(name) || GROUP_PROPERTY_NAMES.contains(name) || path.contains("rep:membersList") || path.contains("rep:members") || path.contains("rep:pwd");
    }

    @Override
    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }
}

