/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.report;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.report.PeriodicReporter;
import org.apache.jackrabbit.oak.plugins.migration.report.ReportingNodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LoggingReporter
extends PeriodicReporter {
    private final Logger logger;
    private final String verb;
    private final LinkedHashMap<String, Boolean> lastPaths = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 100;
        }
    };

    public LoggingReporter(Logger logger, int nodeLogInterval, int propertyLogInterval) {
        this(logger, "Loading", nodeLogInterval, propertyLogInterval);
    }

    public LoggingReporter(Logger logger, String verb, int nodeLogInterval, int propertyLogInterval) {
        super(nodeLogInterval, propertyLogInterval);
        this.logger = logger;
        this.verb = verb;
    }

    @Override
    protected void reportPeriodicNode(long count, @NotNull ReportingNodeState nodeState) {
        this.logger.info("{} node #{}: {}", new Object[]{this.verb, count, nodeState.getPath()});
    }

    @Override
    protected void reportPeriodicProperty(long count, @NotNull ReportingNodeState parent, @NotNull String propertyName) {
        this.logger.info("{} properties #{}: {}", new Object[]{this.verb, count, PathUtils.concat(parent.getPath(), propertyName)});
    }

    @Override
    protected boolean skipNodeState(@NotNull ReportingNodeState nodeState) {
        String path = nodeState.getPath();
        if (this.lastPaths.containsKey(path)) {
            return true;
        }
        this.lastPaths.put(path, Boolean.TRUE);
        return false;
    }
}

