/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    private final ResourceResolver scriptingResourceResolver;

    public DependencyResolver(@NotNull ResourceResolver scriptingResourceResolver) {
        this.scriptingResourceResolver = scriptingResourceResolver;
    }

    @Nullable
    public ScriptNameAwareReader resolve(Bindings bindings, String dependency) {
        if (!Utils.isJsScript(dependency)) {
            throw new SightlyException("Only JS scripts are allowed as dependencies. Invalid dependency: " + dependency);
        }
        Resource scriptResource = this.scriptingResourceResolver.getResource(dependency);
        Resource caller = this.getCaller(bindings);
        if (caller != null) {
            Resource callerType = caller.getParent();
            if (scriptResource == null && callerType != null) {
                SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
                String driverType = request.getResource().getResourceType();
                Resource driver = this.scriptingResourceResolver.getResource(driverType);
                if (driver != null) {
                    Resource hierarchyResource = this.getHierarchyResource(callerType, driver);
                    while (hierarchyResource != null && scriptResource == null) {
                        if (dependency.startsWith("..")) {
                            String absolutePath = ResourceUtil.normalize((String)(hierarchyResource.getPath() + "/" + dependency));
                            if (StringUtils.isNotEmpty((CharSequence)absolutePath)) {
                                scriptResource = this.scriptingResourceResolver.getResource(absolutePath);
                            }
                        } else {
                            scriptResource = hierarchyResource.getChild(dependency);
                        }
                        if (scriptResource != null) continue;
                        String nextType = hierarchyResource.getResourceSuperType();
                        if (nextType != null) {
                            hierarchyResource = this.scriptingResourceResolver.getResource(nextType);
                            continue;
                        }
                        hierarchyResource = null;
                    }
                }
                if (scriptResource == null) {
                    if (dependency.startsWith("..")) {
                        String absolutePath = ResourceUtil.normalize((String)(callerType.getPath() + "/" + dependency));
                        if (StringUtils.isNotEmpty((CharSequence)absolutePath)) {
                            scriptResource = this.scriptingResourceResolver.getResource(absolutePath);
                        }
                    } else {
                        scriptResource = callerType.getChild(dependency);
                    }
                }
            }
        }
        if (scriptResource == null) {
            throw new SightlyException(String.format("Unable to load script dependency %s.", dependency));
        }
        InputStream scriptStream = (InputStream)scriptResource.adaptTo(InputStream.class);
        if (scriptStream == null) {
            throw new SightlyException(String.format("Unable to read script %s.", dependency));
        }
        return new ScriptNameAwareReader((Reader)new InputStreamReader(scriptStream, StandardCharsets.UTF_8), scriptResource.getPath());
    }

    private Resource getCaller(Bindings bindings) {
        SlingScriptHelper scriptHelper;
        Resource caller = null;
        String callerName = (String)bindings.get("javax.script.filename");
        if (StringUtils.isNotEmpty((CharSequence)callerName)) {
            caller = this.scriptingResourceResolver.getResource(callerName);
        }
        if (caller == null && (scriptHelper = Utils.getHelper(bindings)) != null) {
            caller = this.scriptingResourceResolver.getResource(scriptHelper.getScript().getScriptResource().getPath());
        }
        return caller;
    }

    private Resource getHierarchyResource(@NotNull Resource caller, @NotNull Resource driver) {
        if (caller.getPath().equals(driver.getPath())) {
            return caller;
        }
        if (this.isResourceType(caller, driver)) {
            return caller;
        }
        if (this.isResourceType(driver, caller)) {
            return driver;
        }
        int callerOverlayIndex = 0;
        int driverOverlayIndex = 0;
        String callerRelativePath = null;
        String driverRelativePath = null;
        int spIndex = 0;
        for (String sp : this.scriptingResourceResolver.getSearchPath()) {
            if (caller.getPath().startsWith(sp)) {
                callerRelativePath = caller.getPath().substring(sp.length());
                callerOverlayIndex = spIndex;
            }
            if (driver.getPath().startsWith(sp)) {
                driverRelativePath = driver.getPath().substring(sp.length());
                driverOverlayIndex = spIndex;
            }
            if (callerRelativePath != null && driverRelativePath != null) break;
            ++spIndex;
        }
        if (callerRelativePath != null && callerRelativePath.equals(driverRelativePath)) {
            if (callerOverlayIndex < driverOverlayIndex) {
                return caller;
            }
            return driver;
        }
        return null;
    }

    private boolean isResourceType(@NotNull Resource resource, @NotNull Resource parent) {
        if (parent.getPath().equals(resource.getPath())) {
            return true;
        }
        String resourceSuperType = resource.getResourceSuperType();
        while (resourceSuperType != null) {
            Resource intermediateType = this.scriptingResourceResolver.getResource(resourceSuperType);
            if (intermediateType != null) {
                if (intermediateType.getPath().equals(parent.getPath())) {
                    return true;
                }
                resourceSuperType = intermediateType.getResourceSuperType();
                continue;
            }
            return false;
        }
        return false;
    }
}

