/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.api.pagination;

import java.util.Base64;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Cursor {
    private final String rawValue;
    private final String encoded;

    public Cursor(@NotNull String rawValue) {
        if (StringUtils.isEmpty((CharSequence)rawValue)) {
            throw new SlingGraphQLException("Cannot create a cursor from an empty string.");
        }
        this.rawValue = rawValue;
        this.encoded = Cursor.encode(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cursor)) {
            return false;
        }
        Cursor other = (Cursor)obj;
        return Objects.equals(this.rawValue, other.rawValue) && Objects.equals(this.encoded, other.encoded);
    }

    public int hashCode() {
        return Objects.hash(this.rawValue, this.encoded);
    }

    @Nullable
    public static Cursor fromEncodedString(@Nullable String encoded) {
        if (encoded == null) {
            return null;
        }
        if ((encoded = encoded.trim()).length() == 0) {
            return null;
        }
        return new Cursor(Cursor.decode(encoded));
    }

    @NotNull
    static String encode(String rawValue) {
        return Base64.getEncoder().encodeToString(rawValue.getBytes());
    }

    @NotNull
    static String decode(String encodedValue) {
        return new String(Base64.getDecoder().decode(encodedValue));
    }

    public String toString() {
        return this.encoded;
    }

    @NotNull
    public String getRawValue() {
        return this.rawValue;
    }

    @NotNull
    public String getEncoded() {
        return this.encoded;
    }
}

