/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobScheduleBuilderImpl
implements JobBuilder.ScheduleBuilder {
    private final Logger logger = LoggerFactory.getLogger(JobScheduleBuilderImpl.class);
    private final String topic;
    private final Map<String, Object> properties;
    private final String scheduleName;
    private final JobSchedulerImpl jobScheduler;
    private volatile boolean suspend = false;
    private final List<ScheduleInfoImpl> schedules = new ArrayList<ScheduleInfoImpl>();

    public JobScheduleBuilderImpl(String topic, Map<String, Object> properties, String name, JobSchedulerImpl jobScheduler) {
        this.topic = topic;
        this.properties = properties;
        this.scheduleName = name;
        this.jobScheduler = jobScheduler;
    }

    public JobBuilder.ScheduleBuilder weekly(int day, int hour, int minute) {
        this.schedules.add(ScheduleInfoImpl.WEEKLY(day, hour, minute));
        return this;
    }

    public JobBuilder.ScheduleBuilder daily(int hour, int minute) {
        this.schedules.add(ScheduleInfoImpl.DAILY(hour, minute));
        return this;
    }

    public JobBuilder.ScheduleBuilder hourly(int minute) {
        this.schedules.add(ScheduleInfoImpl.HOURLY(minute));
        return this;
    }

    public JobBuilder.ScheduleBuilder at(Date date) {
        this.schedules.add(ScheduleInfoImpl.AT(date));
        return this;
    }

    public JobBuilder.ScheduleBuilder monthly(int day, int hour, int minute) {
        this.schedules.add(ScheduleInfoImpl.MONTHLY(day, hour, minute));
        return this;
    }

    public JobBuilder.ScheduleBuilder yearly(int month, int day, int hour, int minute) {
        this.schedules.add(ScheduleInfoImpl.YEARLY(month, day, hour, minute));
        return this;
    }

    public JobBuilder.ScheduleBuilder cron(String expression) {
        this.schedules.add(ScheduleInfoImpl.CRON(expression));
        return this;
    }

    public ScheduledJobInfo add() {
        return this.add(null);
    }

    public ScheduledJobInfo add(List<String> errors) {
        String finalScheduleName = this.scheduleName;
        if (this.scheduleName == null) {
            finalScheduleName = this.deriveScheduleName();
        }
        return this.jobScheduler.addScheduledJob(this.topic, this.properties, finalScheduleName, this.suspend, this.schedules, errors);
    }

    public JobBuilder.ScheduleBuilder suspend() {
        this.suspend = true;
        return this;
    }

    private String deriveScheduleName() {
        StringBuilder sb = new StringBuilder();
        sb.append("topic=").append(this.topic).append(",suspend=").append(this.suspend).append(",");
        if (this.properties != null) {
            ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                sb.append(key).append("=").append(this.properties.get(key)).append(",");
            }
        }
        sb.append("schedules=").append(this.schedules);
        String scheduleName = sb.toString();
        String hashCode = String.valueOf(scheduleName.hashCode());
        this.logger.debug("calculated scheduleName={}, hash={}", (Object)scheduleName, (Object)hashCode);
        return hashCode;
    }
}

