/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.lang.invoke.CallSite;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.api.wrappers.JavaxToJakartaFilterWrapper;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.FilterPredicate;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.apache.sling.engine.impl.helper.SlingFilterConfig;
import org.apache.sling.engine.jmx.FilterProcessorMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ServletFilterManager.class})
public class ServletFilterManager {
    private static final String JMX_OBJECTNAME = "jmx.objectname";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServletContext servletContext;
    private final SlingFilterChainHelper[] filterChains;
    private final Map<Long, MBeanReg> mbeanMap = new ConcurrentHashMap<Long, MBeanReg>();

    @Activate
    public ServletFilterManager(@Reference(target="(name=org.apache.sling)") ServletContext servletContext) {
        this.servletContext = servletContext;
        this.filterChains = new SlingFilterChainHelper[FilterChainType.values().length];
        for (FilterChainType type : FilterChainType.values()) {
            this.filterChains[type.ordinal()] = new SlingFilterChainHelper();
        }
    }

    public SlingFilterChainHelper getFilterChain(FilterChainType chain) {
        return this.filterChains[chain.ordinal()];
    }

    public FilterHandle[] getFilters(FilterChainType chain) {
        return this.getFilterChain(chain).getFilters();
    }

    @Reference(service=Filter.class, updated="updatedFilter", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(sling.filter.scope=*)")
    public void bindFilter(ServiceReference<Filter> reference, Filter filter) {
        this.initFilter(reference, filter);
    }

    public void updatedFilter(ServiceReference<Filter> reference, Filter service) {
        String newFilterName = SlingFilterConfig.getName(reference);
        if (newFilterName.equals(this.getUsedFilterName(reference))) {
            this.removeFilterFromChains((Long)reference.getProperty("service.id"));
            this.addFilterToChains(service, reference);
        } else {
            this.destroyFilter(reference, service);
            this.initFilter(reference, service);
        }
    }

    public void unbindFilter(ServiceReference<Filter> reference, Filter service) {
        this.destroyFilter(reference, service);
    }

    @Reference(service=javax.servlet.Filter.class, updated="updatedJavaxFilter", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(|(sling.filter.scope=*)(filter.scope=*))")
    public void bindJavaxFilter(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter filter) {
        ServiceReference<javax.servlet.Filter> ref = reference;
        Filter s = JavaxToJakartaFilterWrapper.toJakartaFilter((javax.servlet.Filter)filter);
        this.initFilter(ref, s);
    }

    public void updatedJavaxFilter(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter service) {
        ServiceReference<javax.servlet.Filter> ref = reference;
        Filter s = JavaxToJakartaFilterWrapper.toJakartaFilter((javax.servlet.Filter)service);
        String newFilterName = SlingFilterConfig.getName(ref);
        if (newFilterName.equals(this.getUsedFilterName(ref))) {
            this.removeFilterFromChains((Long)reference.getProperty("service.id"));
            this.addFilterToChains(s, ref);
        } else {
            this.destroyFilter(ref, s);
            this.initFilter(ref, s);
        }
    }

    public void unbindJavaxFilter(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter service) {
        ServiceReference<javax.servlet.Filter> ref = reference;
        Filter s = JavaxToJakartaFilterWrapper.toJakartaFilter((javax.servlet.Filter)service);
        this.destroyFilter(ref, s);
    }

    private void initFilter(ServiceReference<Filter> reference, Filter filter) {
        String filterName = SlingFilterConfig.getName(reference);
        Long serviceId = (Long)reference.getProperty("service.id");
        try {
            try {
                Hashtable<String, CallSite> mbeanProps = new Hashtable<String, CallSite>();
                ((Dictionary)mbeanProps).put(JMX_OBJECTNAME, (CallSite)((Object)("org.apache.sling:type=engine-filter,service=" + filterName)));
                MBeanReg reg = new MBeanReg();
                reg.mbean = new FilterProcessorMBeanImpl();
                reg.registration = reference.getBundle().getBundleContext().registerService(FilterProcessorMBean.class, (Object)reg.mbean, mbeanProps);
                this.mbeanMap.put(serviceId, reg);
            }
            catch (Throwable t) {
                this.log.debug("Unable to register mbean", t);
                Object reg = null;
            }
            SlingFilterConfig config = new SlingFilterConfig(this.servletContext, reference, filterName);
            filter.init((FilterConfig)config);
            this.addFilterToChains(filter, reference);
        }
        catch (ServletException ce) {
            this.log.error("Filter " + filterName + " failed to initialize", (Throwable)ce);
        }
        catch (Throwable t) {
            this.log.error("Unexpected problem initializing filter " + filterName, t);
        }
    }

    private String getUsedFilterName(ServiceReference<Filter> reference) {
        int pos;
        String objectName;
        MBeanReg reg = this.mbeanMap.get(reference.getProperty("service.id"));
        if (reg != null && (objectName = (String)reg.registration.getReference().getProperty(JMX_OBJECTNAME)) != null && (pos = objectName.indexOf(",service=")) != -1) {
            return objectName.substring(pos + 9);
        }
        return null;
    }

    private void destroyFilter(ServiceReference<Filter> reference, Filter filter) {
        Long serviceId = (Long)reference.getProperty("service.id");
        MBeanReg reg = this.mbeanMap.remove(serviceId);
        if (reg != null) {
            reg.registration.unregister();
        }
        if (this.removeFilterFromChains(serviceId)) {
            try {
                filter.destroy();
            }
            catch (Throwable t) {
                this.log.error("Unexpected problem destroying Filter {}", (Object)filter, (Object)t);
            }
        }
    }

    private void addFilterToChains(Filter filter, ServiceReference<Filter> reference) {
        String orderSource;
        Long serviceId = (Long)reference.getProperty("service.id");
        MBeanReg mbeanReg = this.mbeanMap.get(serviceId);
        FilterProcessorMBeanImpl mbean = mbeanReg == null ? null : mbeanReg.mbean;
        Object orderObj = reference.getProperty("service.ranking");
        if (orderObj == null) {
            orderObj = reference.getProperty("filter.order");
            if (orderObj != null) {
                this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.order", "service.ranking"});
                orderSource = "filter.order".concat("=").concat(orderObj.toString());
                orderObj = -1 * (Integer)((Converting)Converters.standardConverter().convert(orderObj).defaultValue((Object)0)).to(Integer.class);
            } else {
                orderSource = "none";
            }
        } else {
            orderSource = "service.ranking".concat("=").concat(orderObj.toString());
        }
        int order = orderObj instanceof Integer ? (Integer)orderObj : 0;
        Object scopeValue = reference.getProperty("sling.filter.scope");
        if (scopeValue == null) {
            scopeValue = reference.getProperty("filter.scope");
            this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.scope", "sling.filter.scope"});
        }
        String[] scopes = (String[])Converters.standardConverter().convert(scopeValue).to(String[].class);
        FilterPredicate predicate = new FilterPredicate(reference);
        boolean used = false;
        for (String scope : scopes) {
            scope = scope.toUpperCase();
            try {
                FilterChainType type = FilterChainType.valueOf(scope.toString());
                this.getFilterChain(type).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                if (type == FilterChainType.COMPONENT) {
                    this.getFilterChain(FilterChainType.INCLUDE).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                    this.getFilterChain(FilterChainType.FORWARD).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                }
                used = true;
            }
            catch (IllegalArgumentException iae) {
                this.log.warn("Filter service {} has invalid value {} for scope. Value is ignored", reference, (Object)scope);
            }
        }
        if (!used) {
            this.log.warn("Filter service {} has been registered without a valid {} property. The filter is ignored and not used.", (Object)serviceId, (Object)"sling.filter.scope");
        }
    }

    private boolean removeFilterFromChains(Long serviceId) {
        boolean removed = false;
        for (SlingFilterChainHelper filterChain : this.filterChains) {
            removed |= filterChain.removeFilterById(serviceId);
        }
        return removed;
    }

    public static enum FilterChainType {
        REQUEST("Request"),
        ERROR("Error"),
        INCLUDE("Include"),
        FORWARD("Forward"),
        COMPONENT("Component");

        private final String message;

        private FilterChainType(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    private static final class MBeanReg {
        FilterProcessorMBeanImpl mbean;
        ServiceRegistration<FilterProcessorMBean> registration;

        private MBeanReg() {
        }
    }
}

