/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.monitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={HealthCheck.class}, property={"hc.name=SlingDistributionQueueHC", "hc.mbean.name=slingDistributionQueue"})
@Designate(ocd=Config.class)
public class DistributionQueueHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(DistributionQueueHealthCheck.class);
    private static final int DEFAULT_NUMBER_OF_RETRIES_ALLOWED = 3;
    private int numberOfRetriesAllowed;
    private final List<DistributionAgent> distributionAgents = new CopyOnWriteArrayList<DistributionAgent>();

    @Activate
    public void activate(Config conf) {
        this.numberOfRetriesAllowed = conf.numberOfRetriesAllowed();
        log.info("Activated, numberOfRetriesAllowed={}", (Object)this.numberOfRetriesAllowed);
    }

    @Deactivate
    protected void deactivate() {
        this.distributionAgents.clear();
    }

    @Reference(name="distributionAgent", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void bindDistributionAgent(DistributionAgent distributionAgent) {
        this.distributionAgents.add(distributionAgent);
        log.debug("Registering distribution agent {} ", (Object)distributionAgent);
    }

    protected void unbindDistributionAgent(DistributionAgent distributionAgent) {
        this.distributionAgents.remove(distributionAgent);
        log.debug("Unregistering distribution agent {} ", (Object)distributionAgent);
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        HashMap<String, Integer> failures = new HashMap<String, Integer>();
        if (this.distributionAgents.size() > 0) {
            for (DistributionAgent distributionAgent : this.distributionAgents) {
                for (String queueName : distributionAgent.getQueueNames()) {
                    try {
                        DistributionQueue q = distributionAgent.getQueue(queueName);
                        DistributionQueueEntry entry = q.getHead();
                        if (entry != null) {
                            DistributionQueueItemStatus status = entry.getStatus();
                            if (status.getAttempts() <= this.numberOfRetriesAllowed) {
                                resultLog.debug("Queue: [{}], first item: [{}], number of retries: {}", new Object[]{q.getName(), entry.getId(), status.getAttempts()});
                                continue;
                            }
                            resultLog.warn("Queue: [{}], first item: [{}], number of retries: {}, expected number of retries <= {}", new Object[]{q.getName(), entry.getId(), status.getAttempts(), this.numberOfRetriesAllowed});
                            failures.put(q.getName(), status.getAttempts());
                            continue;
                        }
                        resultLog.debug("No items in queue [{}]", new Object[]{q.getName()});
                    }
                    catch (Exception e) {
                        resultLog.warn("Exception while inspecting distribution queue [{}]: {}", new Object[]{queueName, e});
                    }
                }
            }
        } else {
            resultLog.debug("No distribution queue providers found", new Object[0]);
        }
        if (failures.size() > 0) {
            for (Map.Entry entry : failures.entrySet()) {
                resultLog.warn("Distribution queue {}'s first item in the default queue has been retried {} times (threshold: {})", new Object[]{entry.getKey(), entry.getValue(), this.numberOfRetriesAllowed});
            }
        }
        return new Result((ResultLog)resultLog);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Queue Health Check")
    public static @interface Config {
        @AttributeDefinition(name="Allowed retries", description="Number of allowed retries")
        public int numberOfRetriesAllowed() default 3;
    }
}

