/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import org.apache.sling.auth.core.impl.PathBasedHolder;
import org.osgi.framework.ServiceReference;

class AuthenticationRequirementHolder
extends PathBasedHolder {
    private final boolean requiresAuthentication;

    static AuthenticationRequirementHolder fromConfig(String config, ServiceReference<?> serviceReference) {
        String path;
        boolean required;
        if (config == null || config.length() == 0) {
            throw new IllegalArgumentException("Configuration must not be null or empty");
        }
        if (config.startsWith("+")) {
            required = true;
            path = config.substring(1);
        } else if (config.startsWith("-")) {
            required = false;
            path = config.substring(1);
        } else {
            required = true;
            path = config;
        }
        return new AuthenticationRequirementHolder(path, required, serviceReference);
    }

    AuthenticationRequirementHolder(String fullPath, boolean requiresAuthentication, ServiceReference<?> serviceReference) {
        super(fullPath, serviceReference);
        this.requiresAuthentication = requiresAuthentication;
    }

    boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.requiresAuthentication ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationRequirementHolder other = (AuthenticationRequirementHolder)obj;
        return this.requiresAuthentication == other.requiresAuthentication;
    }
}

