/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.util.Collection;
import java.util.function.IntFunction;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.util.ArraysExt;
import org.opengis.metadata.Metadata;

abstract class Section<T>
extends GridPane
implements EventHandler<ActionEvent> {
    final MetadataSummary owner;
    static final int NUM_CHILD_PER_LINE = 2;
    private final TilePane pagination;
    private final ToggleGroup pageGroup;
    private T[] information;
    private int rowOfFirstLine;
    private int linesStartIndex;
    private int linesEndIndex;

    Section(MetadataSummary owner) {
        this.owner = owner;
        this.pageGroup = new ToggleGroup();
        this.pagination = new TilePane(Orientation.VERTICAL);
        this.pagination.setAlignment(Pos.TOP_RIGHT);
        this.pagination.setVgap(9.0);
        this.pagination.setHgap(9.0);
        this.setPadding(Styles.FORM_INSETS);
        this.setVgap(9.0);
        this.setHgap(9.0);
        this.add((Node)this.pagination, 2, 0);
        Section.setVgrow((Node)this.pagination, (Priority)Priority.ALWAYS);
        Section.setHgrow((Node)this.pagination, (Priority)Priority.NEVER);
        this.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), new ColumnConstraints(100.0, 300.0, Double.MAX_VALUE, Priority.ALWAYS, null, true)});
    }

    final void finished() {
        this.rowOfFirstLine = this.getRowCount();
        this.linesStartIndex = this.getChildren().size();
    }

    final int numPages() {
        return this.information != null ? this.information.length : 0;
    }

    abstract void setInformation(Metadata var1);

    final void setInformation(Collection<? extends T> info, IntFunction<T[]> generator) {
        this.information = info.toArray(generator);
        int n = 0;
        for (T e : this.information) {
            if (e == null) continue;
            this.information[n++] = e;
        }
        this.information = ArraysExt.resize((Object[])this.information, (int)n);
        ObservableList pages = this.pagination.getChildren();
        int i = pages.size();
        if (i < n) {
            do {
                ToggleButton b = new ToggleButton(this.owner.format(++i));
                b.setToggleGroup(this.pageGroup);
                b.setOnAction((EventHandler)this);
                pages.add((Object)b);
            } while (i < n);
        } else if (i > n) {
            pages.subList(n, i).clear();
        }
        this.linesEndIndex = this.linesStartIndex;
        if (n != 0) {
            this.pageGroup.selectToggle((Toggle)((ToggleButton)this.pagination.getChildren().get(0)));
            this.update(0);
        }
    }

    public final void handle(ActionEvent event) {
        ToggleButton source = (ToggleButton)event.getSource();
        if (source.isSelected()) {
            ObservableList children = this.pagination.getChildren();
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                if (children.get(i) != source) continue;
                this.update(i);
                break;
            }
        }
    }

    private void update(int index) {
        this.linesEndIndex = this.linesStartIndex;
        this.buildContent(this.information[index]);
        Section.setRowSpan((Node)this.pagination, (Integer)this.nextRowIndex());
        ObservableList children = this.getChildren();
        children.subList(this.linesEndIndex, children.size()).clear();
        Section.setRowSpan((Node)this.pagination, (Integer)this.getRowCount());
    }

    abstract void buildContent(T var1);

    final void addLine(short label, String value) {
        Label valueCtrl;
        if (value == null) {
            return;
        }
        String labelText = this.owner.vocabulary.getLabel(label);
        ObservableList children = this.getChildren();
        if (this.linesEndIndex < children.size()) {
            Label labelCtrl = (Label)children.get(this.linesEndIndex);
            valueCtrl = (Label)children.get(this.linesEndIndex + 1);
            labelCtrl.setText(labelText);
        } else {
            int row = this.nextRowIndex();
            Label labelCtrl = new Label(labelText);
            valueCtrl = new Label();
            labelCtrl.setLabelFor((Node)valueCtrl);
            valueCtrl.setWrapText(true);
            this.add((Node)labelCtrl, 0, row);
            this.add((Node)valueCtrl, 1, row);
            Section.setValignment((Node)labelCtrl, (VPos)VPos.TOP);
            Section.setValignment((Node)valueCtrl, (VPos)VPos.TOP);
        }
        valueCtrl.setText(value);
        this.linesEndIndex += 2;
    }

    final int nextRowIndex() {
        return (this.linesEndIndex - this.linesStartIndex) / 2 + this.rowOfFirstLine;
    }

    final int linesStartIndex() {
        return this.linesStartIndex;
    }

    boolean isEmpty() {
        return this.linesStartIndex >= this.linesEndIndex;
    }
}

