/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Region;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.gui.dataset.LogViewer;
import org.apache.sis.gui.dataset.ResourceEvent;
import org.apache.sis.gui.dataset.ResourceTree;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.MetadataTree;
import org.apache.sis.gui.metadata.StandardMetadataTree;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;

public class ResourceExplorer
extends Widget {
    private final ResourceTree resources = new ResourceTree();
    private final ReadOnlyObjectWrapper<Resource> selectedResource;
    private final MetadataSummary metadata;
    private final MetadataTree nativeMetadata;
    private final Tab nativeMetadataTab;
    private final String defaultNativeTabLabel;
    private CoverageExplorer coverage;
    private FeatureTable features;
    private CoverageExplorer.View coverageView;
    private final EnumMap<CoverageExplorer.View, TitledPane> expandedPane;
    private final Accordion controls;
    private final SplitPane content;
    private final Tab viewTab;
    private final Tab tableTab;
    private final BooleanBinding dataShown;
    private final BooleanBinding metadataShown;

    public ResourceExplorer() {
        Tab loggingTab;
        Tab metadataTab;
        this.resources.getSelectionModel().getSelectedItems().addListener(this::onResourceSelected);
        this.resources.setPrefWidth(400.0);
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)this.resources.locale);
        TitledPane resourcesPane = new TitledPane(vocabulary.getString((short)263), (Node)this.resources);
        this.controls = new Accordion(new TitledPane[]{resourcesPane});
        this.controls.setExpandedPane(resourcesPane);
        this.expandedPane = new EnumMap(CoverageExplorer.View.class);
        this.metadata = new MetadataSummary();
        this.nativeMetadata = new MetadataTree(this.metadata);
        LogViewer logging = new LogViewer(vocabulary);
        this.selectedResource = new ReadOnlyObjectWrapper((Object)this, "selectedResource");
        logging.source.bind(this.selectedResource);
        Tab summaryTab = new Tab(vocabulary.getString((short)189), (Node)this.metadata.getView());
        TabPane tabs = new TabPane(new Tab[]{summaryTab, this.viewTab = new Tab(vocabulary.getString((short)221)), this.tableTab = new Tab(vocabulary.getString((short)47)), metadataTab = new Tab(vocabulary.getString((short)131), (Node)new StandardMetadataTree(this.metadata)), this.nativeMetadataTab = new Tab(vocabulary.getString((short)85), (Node)this.nativeMetadata), loggingTab = new Tab(vocabulary.getString((short)244), (Node)logging.getView())});
        tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabs.setTabDragPolicy(TabPane.TabDragPolicy.REORDER);
        this.defaultNativeTabLabel = this.nativeMetadataTab.getText();
        this.nativeMetadataTab.setDisable(true);
        this.content = new SplitPane(new Node[]{this.controls, tabs});
        this.content.setDividerPosition(0, 0.3333333333333333);
        SplitPane.setResizableWithParent((Node)this.controls, (Boolean)Boolean.FALSE);
        SplitPane.setResizableWithParent((Node)tabs, (Boolean)Boolean.TRUE);
        loggingTab.disableProperty().bind((ObservableValue)logging.isEmptyProperty());
        this.dataShown = this.viewTab.selectedProperty().or((ObservableBooleanValue)this.tableTab.selectedProperty());
        this.dataShown.addListener((p, o, n) -> {
            if (Boolean.FALSE.equals(o) && Boolean.TRUE.equals(n)) {
                this.updateDataTabWithDefault(this.getSelectedResource());
            } else {
                this.updateDataTab(null);
            }
        });
        this.metadataShown = summaryTab.selectedProperty().or((ObservableBooleanValue)metadataTab.selectedProperty());
        this.metadataShown.addListener((p, o, n) -> {
            if (Boolean.FALSE.equals(o) && Boolean.TRUE.equals(n)) {
                this.metadata.setMetadata(this.getSelectedResource());
            }
        });
        this.nativeMetadataTab.selectedProperty().addListener((p, o, n) -> {
            if (Boolean.FALSE.equals(o) && Boolean.TRUE.equals(n)) {
                this.loadNativeMetadata();
            }
        });
    }

    @Override
    public final Locale getLocale() {
        return this.resources.locale;
    }

    @Override
    public final Region getView() {
        return this.content;
    }

    public EventHandler<ResourceEvent> getOnResourceLoaded() {
        return (EventHandler)this.resources.onResourceLoaded.get();
    }

    public void setOnResourceLoaded(EventHandler<ResourceEvent> handler) {
        this.resources.onResourceLoaded.set(handler);
    }

    public EventHandler<ResourceEvent> getOnResourceClosed() {
        return (EventHandler)this.resources.onResourceClosed.get();
    }

    public void setOnResourceClosed(EventHandler<ResourceEvent> handler) {
        this.resources.onResourceClosed.set(handler);
    }

    public void loadResources(Collection<?> files) {
        for (Object file : files) {
            this.resources.loadResource(file);
        }
    }

    public void removeAndClose(Resource resource) {
        this.resources.removeAndClose(resource);
    }

    public final Resource getSelectedResource() {
        return (Resource)this.selectedResource.get();
    }

    public final ReadOnlyProperty<Resource> selectedResourceProperty() {
        return this.selectedResource.getReadOnlyProperty();
    }

    private void onResourceSelected(ListChangeListener.Change<? extends TreeItem<Resource>> change) {
        TreeItem item;
        Resource resource = null;
        Iterator iterator = change.getList().iterator();
        while (iterator.hasNext() && ((item = (TreeItem)iterator.next()) == null || (resource = (Resource)item.getValue()) == null)) {
        }
        this.selectedResource.set(resource);
        this.metadata.setMetadata((Resource)(this.metadataShown.get() ? resource : null));
        this.updateDataTabWithDefault((Resource)(this.dataShown.get() ? resource : null));
        String label = null;
        boolean disabled = true;
        if (resource instanceof DataStore) {
            DataStore store = (DataStore)resource;
            DataStoreProvider provider = store.getProvider();
            if (provider != null) {
                label = provider.getShortName();
            }
            try {
                disabled = resource.getClass().getMethod("getNativeMetadata", new Class[0]).getDeclaringClass() == DataStore.class;
            }
            catch (NoSuchMethodException e) {
                ResourceExplorer.warning("onResourceSelected", resource, e);
            }
        }
        this.nativeMetadataTab.setText(Objects.toString(label, this.defaultNativeTabLabel));
        this.nativeMetadataTab.setDisable(disabled);
        this.nativeMetadata.setPlaceholder(null);
        this.nativeMetadata.setContent(null);
        if (this.nativeMetadataTab.isSelected()) {
            this.loadNativeMetadata();
        }
    }

    private void loadNativeMetadata() {
        final Resource resource = this.getSelectedResource();
        if (resource instanceof DataStore) {
            final DataStore store = (DataStore)resource;
            BackgroundThreads.execute((Runnable)new Task<TreeTable>(this){
                final /* synthetic */ ResourceExplorer this$0;
                {
                    this.this$0 = this$0;
                }

                protected TreeTable call() throws DataStoreException {
                    return store.getNativeMetadata().orElse(null);
                }

                protected void succeeded() {
                    if (resource == this.this$0.getSelectedResource()) {
                        this.this$0.nativeMetadata.setContent((TreeTable)this.getValue());
                    }
                }

                protected void failed() {
                    this.this$0.nativeMetadata.setPlaceholder((Node)new ExceptionReporter(this.getException()).getView());
                }
            });
        }
    }

    private CoverageExplorer.View getCoverageView() {
        if (this.viewTab.isSelected()) {
            return CoverageExplorer.View.IMAGE;
        }
        if (this.tableTab.isSelected()) {
            return CoverageExplorer.View.TABLE;
        }
        return null;
    }

    private boolean updateDataTab(Resource resource) {
        Region image = null;
        FeatureTable table = null;
        FeatureSet data = null;
        ImageRequest grid = null;
        Object[] cpanes = null;
        CoverageExplorer.View type = this.getCoverageView();
        if (resource instanceof GridCoverageResource) {
            if (this.coverage == null) {
                this.coverage = new CoverageExplorer(type);
            } else {
                this.coverage.setViewType(type);
            }
            Region view = this.coverage.getDataView(type);
            switch (type) {
                case IMAGE: {
                    image = view;
                    break;
                }
                case TABLE: {
                    table = view;
                }
            }
            grid = new ImageRequest((GridCoverageResource)resource, null, null);
            cpanes = this.coverage.getControls(type);
        } else if (resource instanceof FeatureSet) {
            data = (FeatureSet)resource;
            if (this.features == null) {
                this.features = new FeatureTable();
            }
            table = this.features;
        }
        if (this.coverage != null) {
            this.coverage.setCoverage(grid);
        }
        if (this.features != null) {
            this.features.setFeatures(data);
        }
        if (image != null) {
            this.viewTab.setContent(image);
        }
        if (table != null) {
            this.tableTab.setContent((Node)table);
        }
        boolean isEmpty = image == null & table == null;
        TitledPane expanded = this.controls.getExpandedPane();
        if (expanded != null && this.coverageView != null) {
            this.expandedPane.put(this.coverageView, expanded);
        }
        ObservableList items = this.controls.getPanes();
        int size = items.size();
        items.remove(1, size);
        if (cpanes != null) {
            items.addAll(cpanes);
            if (!items.contains((Object)expanded) && (expanded = this.expandedPane.get((Object)type)) != null) {
                this.controls.setExpandedPane(expanded);
            }
        }
        this.coverageView = type;
        return !isEmpty | resource == null;
    }

    private void updateDataTabWithDefault(final Resource resource) {
        if (this.updateDataTab(resource)) {
            return;
        }
        if (resource instanceof Aggregate && !(resource instanceof DataSet)) {
            BackgroundThreads.execute((Runnable)new Task<Resource>(this){
                final /* synthetic */ ResourceExplorer this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Resource call() throws DataStoreException {
                    Long id = LogHandler.loadingStart(resource);
                    try {
                        for (Resource component : ((Aggregate)resource).components()) {
                            if (!(component instanceof DataSet)) continue;
                            Resource resource2 = component;
                            return resource2;
                        }
                    }
                    finally {
                        LogHandler.loadingStop(id);
                    }
                    return null;
                }

                protected void succeeded() {
                    if (this.this$0.getSelectedResource() == resource) {
                        this.this$0.updateDataTab((Resource)this.getValue());
                    }
                }

                protected void failed() {
                    ResourceExplorer.warning("updateDataTabWithDefault", resource, this.getException());
                }
            });
        }
    }

    private static void warning(String caller, Resource resource, Throwable error) {
        LogHandler.Destination records = LogHandler.getRecords(resource);
        if (records != null) {
            LogRecord record = new LogRecord(Level.WARNING, error.getLocalizedMessage());
            record.setSourceClassName(ResourceExplorer.class.getName());
            record.setSourceMethodName(caller);
            record.setThrown(error);
            records.add(record);
        }
    }
}

