/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalFeatureTypeException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.storage.gpx.Bounds;
import org.apache.sis.storage.gpx.Link;
import org.apache.sis.storage.gpx.Metadata;
import org.apache.sis.storage.gpx.Person;
import org.apache.sis.storage.gpx.StoreProvider;
import org.apache.sis.storage.gpx.Types;
import org.apache.sis.storage.gpx.WritableStore;
import org.apache.sis.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.util.Version;

final class Writer
extends StaxStreamWriter {
    private final int version;
    private final Metadata metadata;

    Writer(WritableStore owner, Metadata metadata, OutputStream temporary) throws DataStoreException, XMLStreamException, IOException {
        super(owner, temporary);
        this.metadata = metadata;
        Version ver = owner.version;
        this.version = ver != null && ver.compareTo(StoreProvider.V1_0, 2) <= 0 ? 0 : 1;
    }

    @Override
    public void writeStartDocument() throws Exception {
        String namespace;
        Version ver;
        switch (this.version) {
            default: {
                ver = StoreProvider.V1_1;
                namespace = "http://www.topografix.com/GPX/1/1";
                break;
            }
            case 0: {
                ver = StoreProvider.V1_0;
                namespace = "http://www.topografix.com/GPX/1/0";
            }
        }
        super.writeStartDocument();
        this.writer.setDefaultNamespace(namespace);
        this.writer.writeStartElement("gpx");
        this.writer.writeDefaultNamespace(namespace);
        this.writer.writeAttribute("version", ver.toString());
        if (this.metadata != null) {
            String creator = this.metadata.creator;
            if (creator != null) {
                this.writer.writeAttribute("creator", creator);
            }
            switch (this.version) {
                default: {
                    this.marshal("http://www.topografix.com/GPX/1/1", "metadata", Metadata.class, this.metadata);
                    break;
                }
                case 0: {
                    this.writeSingleValue("name", this.metadata.name);
                    this.writeSingleValue("desc", this.metadata.description);
                    Person author = this.metadata.author;
                    if (author != null) {
                        this.writeSingleValue("author", author.name);
                        this.writeSingleValue("email", author.email);
                    }
                    this.writeLinks(this.metadata.links);
                    this.writeSingle("time", this.metadata.time);
                    this.writeList("keywords", this.metadata.keywords);
                    this.marshal("http://www.topografix.com/GPX/1/1", "bounds", Bounds.class, this.metadata.bounds);
                }
            }
        }
    }

    @Override
    public void write(AbstractFeature feature) throws DataStoreException, XMLStreamException, JAXBException {
        if (feature != null) {
            Types types = ((WritableStore)this.owner).types;
            DefaultFeatureType type = feature.getType();
            if (types.wayPoint.isAssignableFrom(type)) {
                this.writeWayPoint(feature, "wpt");
            } else {
                boolean isRoute = types.route.isAssignableFrom(type);
                if (!isRoute && !types.track.isAssignableFrom(type)) {
                    throw new IllegalFeatureTypeException(this.owner.getLocale(), this.owner.getFormatName(), type.getName());
                }
                this.writer.writeStartElement(isRoute ? "rte" : "trk");
                this.writeSingleValue("name", feature.getPropertyValue("name"));
                this.writeSingleValue("cmt", feature.getPropertyValue("cmt"));
                this.writeSingleValue("desc", feature.getPropertyValue("desc"));
                this.writeSingleValue("src", feature.getPropertyValue("src"));
                this.writeLinks((Collection)feature.getPropertyValue("link"));
                this.writeSingleValue("number", feature.getPropertyValue("number"));
                if (this.version != 0) {
                    this.writeSingleValue("type", feature.getPropertyValue("type"));
                }
                if (isRoute) {
                    for (Object prop : (Collection)feature.getPropertyValue("rtept")) {
                        this.writeWayPoint((AbstractFeature)prop, "rtept");
                    }
                } else {
                    for (Object segment : (Collection)feature.getPropertyValue("trkseg")) {
                        if (segment == null) continue;
                        this.writer.writeStartElement("trkseg");
                        for (Object prop : (Collection)((AbstractFeature)segment).getPropertyValue("trkpt")) {
                            this.writeWayPoint((AbstractFeature)prop, "trkpt");
                        }
                        this.writer.writeEndElement();
                    }
                }
                this.writer.writeEndElement();
            }
        }
    }

    private void writeWayPoint(AbstractFeature feature, String tagName) throws XMLStreamException, JAXBException {
        double[] pt;
        if (feature != null && (pt = (double[])Geometries.wrap((Object)feature.getPropertyValue("sis:geometry")).map(GeometryWrapper::getPointCoordinates).orElse(null)) != null && pt.length >= 2) {
            this.writer.writeStartElement(tagName);
            this.writer.writeAttribute("lat", Double.toString(pt[1]));
            this.writer.writeAttribute("lon", Double.toString(pt[0]));
            this.writeSingleValue("ele", feature.getPropertyValue("ele"));
            this.writeSingleValue("time", feature.getPropertyValue("time"));
            this.writeSingleValue("magvar", feature.getPropertyValue("magvar"));
            this.writeSingleValue("geoidheight", feature.getPropertyValue("geoidheight"));
            this.writeSingleValue("name", feature.getPropertyValue("name"));
            this.writeSingleValue("cmt", feature.getPropertyValue("cmt"));
            this.writeSingleValue("desc", feature.getPropertyValue("desc"));
            this.writeSingleValue("src", feature.getPropertyValue("src"));
            this.writeLinks((Collection)feature.getPropertyValue("link"));
            this.writeSingleValue("sym", feature.getPropertyValue("sym"));
            this.writeSingleValue("type", feature.getPropertyValue("type"));
            this.writeSingle((Fix)((Object)feature.getPropertyValue("fix")));
            this.writeSingleValue("sat", feature.getPropertyValue("sat"));
            this.writeSingleValue("hdop", feature.getPropertyValue("hdop"));
            this.writeSingleValue("vdop", feature.getPropertyValue("vdop"));
            this.writeSingleValue("pdop", feature.getPropertyValue("pdop"));
            this.writeSingleValue("ageofdgpsdata", feature.getPropertyValue("ageofdgpsdata"));
            this.writeSingleValue("dgpsid", feature.getPropertyValue("dgpsid"));
            this.writer.writeEndElement();
        }
    }

    private void writeSingle(Fix fix) throws XMLStreamException {
        if (fix != null) {
            this.writeSingleValue("fix", fix.toGPX());
        }
    }

    private void writeLinks(Collection<?> links) throws XMLStreamException, JAXBException {
        if (links != null) {
            block3: for (Object link : links) {
                if (link == null) continue;
                switch (this.version) {
                    default: {
                        this.marshal("http://www.topografix.com/GPX/1/1", "link", Link.class, (Link)link);
                        continue block3;
                    }
                    case 0: 
                }
                this.writeSingleValue("url", ((Link)link).uri.toASCIIString());
                this.writeSingleValue("urlname", ((Link)link).text);
                return;
            }
        }
    }
}

