/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.internal.shared;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.ExternalLinkHandler;
import org.xml.sax.SAXParseException;

public final class ExceptionSimplifier {
    private short errorKey;
    private Object[] errorValues;
    public final Exception exception;

    public ExceptionSimplifier(Object source, Exception exception) {
        ExternalLinkHandler handler;
        int line = -1;
        int column = -1;
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            String s;
            if (cause instanceof SAXParseException) {
                SAXParseException s2 = (SAXParseException)cause;
                if ((line | column) < 0) {
                    line = s2.getLineNumber();
                    column = s2.getColumnNumber();
                }
                if (source == null && (source = s2.getPublicId()) == null) {
                    source = s2.getSystemId();
                }
            }
            if (cause == exception) continue;
            String msg = exception.getMessage();
            if (msg != null && (s = cause.getMessage()) != null && !msg.contains(s)) break;
            if (!exception.getClass().isInstance(cause)) continue;
            exception = (Exception)cause;
        }
        this.exception = exception;
        if (source == null && (handler = Context.linkHandler(Context.current())) != null) {
            source = handler.getBase();
        }
        if (source != null) {
            if ((line | column) < 0) {
                this.errorKey = (short)19;
                this.errorValues = new Object[]{source};
            } else {
                this.errorKey = (short)20;
                this.errorValues = new Object[]{source, line, column};
            }
        }
    }

    public String getMessage(Locale locale) {
        if (this.errorKey != 0) {
            return Errors.forLocale((Locale)locale).getString(this.errorKey, (Object)this.errorValues);
        }
        return this.exception.getMessage();
    }

    public void report(Context context, Class<?> classe, String method) {
        Context.warningOccured(context, Level.WARNING, classe, method, this.exception, this.errorKey != 0 ? Errors.class : null, this.errorKey, this.errorValues);
    }

    public LogRecord record(Class<?> classe, String method) {
        LogRecord record = this.errorKey != 0 ? Errors.forLocale(null).createLogRecord(Level.WARNING, this.errorKey, (Object)this.errorValues) : new LogRecord(Level.WARNING, this.exception.getMessage());
        record.setLoggerName("org.apache.sis.xml");
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(method);
        record.setThrown(this.exception);
        return record;
    }
}

