/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.metadata.replace;

import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.metadata.internal.shared.ReferencingServices;
import org.apache.sis.metadata.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.TypeName;

abstract class Parameter<T>
extends SimpleIdentifiedObject
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = 1120310941894856951L;
    private volatile transient ParameterDescriptor<T> descriptor;

    Parameter() {
    }

    Parameter(ParameterDescriptor<T> parameter) {
        super((IdentifiedObject)parameter);
        this.descriptor = parameter;
    }

    public TypeName getValueType() {
        return ReferencingServices.getInstance().getValueType(this.descriptor);
    }

    public Class<T> getValueClass() {
        ParameterDescriptor<T> p = this.descriptor;
        return p != null ? p.getValueClass() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ParameterValue<T> createValue() {
        ParameterDescriptor<T> p;
        Parameter parameter = this;
        synchronized (parameter) {
            p = this.descriptor;
            if (p == null) {
                this.descriptor = p = ReferencingServices.getInstance().toImplementation(this);
            }
        }
        return p.createValue();
    }

    public Set<T> getValidValues() {
        return null;
    }

    public Comparable<T> getMinimumValue() {
        return null;
    }

    public Comparable<T> getMaximumValue() {
        return null;
    }

    public T getDefaultValue() {
        return null;
    }

    public Unit<?> getUnit() {
        return null;
    }

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        ParameterDescriptor that;
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode) && object instanceof ParameterDescriptor && (that = (ParameterDescriptor)object).getUnit() == null && that.getDefaultValue() == null && that.getValueClass() == this.getValueClass()) {
            if (mode.isIgnoringMetadata()) {
                return Objects.equals(Parameter.toString((Identifier)this.getName()), Parameter.toString((Identifier)that.getName()));
            }
            return that.getMinimumOccurs() == this.getMinimumOccurs() && that.getMaximumOccurs() == this.getMaximumOccurs() && that.getValidValues() == null && that.getMinimumValue() == null && that.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

