/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Algorithm;
import org.opengis.metadata.lineage.Processing;
import org.opengis.util.InternationalString;

@XmlType(name="LE_Processing_Type", propOrder={"identifier", "softwareReferences", "procedureDescription", "documentations", "runTimeParameters", "algorithms"})
@XmlRootElement(name="LE_Processing")
public class DefaultProcessing
extends ISOMetadata
implements Processing {
    private static final long serialVersionUID = 5698533358975632857L;
    private Collection<Citation> softwareReferences;
    private InternationalString procedureDescription;
    private Collection<Citation> documentations;
    private InternationalString runTimeParameters;
    private Collection<Algorithm> algorithms;

    public DefaultProcessing() {
    }

    public DefaultProcessing(Processing object) {
        super(object);
        if (object != null) {
            this.identifiers = DefaultProcessing.singleton(object.getIdentifier(), Identifier.class);
            this.softwareReferences = DefaultProcessing.copyCollection(object.getSoftwareReferences(), Citation.class);
            this.procedureDescription = object.getProcedureDescription();
            this.documentations = DefaultProcessing.copyCollection(object.getDocumentations(), Citation.class);
            this.runTimeParameters = object.getRunTimeParameters();
            this.algorithms = DefaultProcessing.copyCollection(object.getAlgorithms(), Algorithm.class);
        }
    }

    public static DefaultProcessing castOrCopy(Processing object) {
        if (object == null || object instanceof DefaultProcessing) {
            return (DefaultProcessing)object;
        }
        return new DefaultProcessing(object);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="softwareReference")
    public Collection<Citation> getSoftwareReferences() {
        this.softwareReferences = this.nonNullCollection(this.softwareReferences, Citation.class);
        return this.softwareReferences;
    }

    public void setSoftwareReferences(Collection<? extends Citation> newValues) {
        this.softwareReferences = this.writeCollection(newValues, this.softwareReferences, Citation.class);
    }

    @XmlElement(name="procedureDescription")
    public InternationalString getProcedureDescription() {
        return this.procedureDescription;
    }

    public void setProcedureDescription(InternationalString newValue) {
        this.checkWritePermission(this.procedureDescription);
        this.procedureDescription = newValue;
    }

    @XmlElement(name="documentation")
    public Collection<Citation> getDocumentations() {
        this.documentations = this.nonNullCollection(this.documentations, Citation.class);
        return this.documentations;
    }

    public void setDocumentations(Collection<? extends Citation> newValues) {
        this.documentations = this.writeCollection(newValues, this.documentations, Citation.class);
    }

    @XmlElement(name="runTimeParameters")
    public InternationalString getRunTimeParameters() {
        return this.runTimeParameters;
    }

    public void setRunTimeParameters(InternationalString newValue) {
        this.checkWritePermission(this.runTimeParameters);
        this.runTimeParameters = newValue;
    }

    @XmlElement(name="algorithm")
    public Collection<Algorithm> getAlgorithms() {
        this.algorithms = this.nonNullCollection(this.algorithms, Algorithm.class);
        return this.algorithms;
    }

    public void setAlgorithms(Collection<? extends Algorithm> newValues) {
        this.algorithms = this.writeCollection(newValues, this.algorithms, Algorithm.class);
    }
}

