/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.iso.identification.DefaultRepresentativeFraction;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.internal.shared.Cloner;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;

final class StateChanger
extends MetadataVisitor<Boolean> {
    private static final ThreadLocal<StateChanger> VISITORS = ThreadLocal.withInitial(StateChanger::new);
    private ModifiableMetadata.State target;
    private Cloner cloner;

    private StateChanger() {
    }

    static void applyTo(ModifiableMetadata.State target, ModifiableMetadata metadata) {
        StateChanger changer = VISITORS.get();
        ModifiableMetadata.State previous = changer.target;
        changer.target = target;
        changer.walk(metadata.getStandard(), null, metadata, true);
        changer.target = previous;
    }

    @Override
    final ThreadLocal<StateChanger> creator() {
        return VISITORS;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor accessor) {
        return MetadataVisitor.Filter.WRITABLE;
    }

    @Override
    final Object visit(Class<?> type, Object object) throws CloneNotSupportedException {
        return this.applyTo(object);
    }

    private void applyToAll(Object[] array) throws CloneNotSupportedException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.applyTo(array[i]);
        }
    }

    private Object applyTo(Object object) throws CloneNotSupportedException {
        if (object instanceof ModifiableMetadata) {
            ((ModifiableMetadata)object).transitionTo(this.target);
            return object;
        }
        if (object instanceof DefaultRepresentativeFraction && this.target.isUnmodifiable()) {
            ((DefaultRepresentativeFraction)object).freeze();
            return object;
        }
        if (object instanceof Collection) {
            Set collection = (Set)object;
            boolean isSet = collection instanceof Set;
            Object[] objectArray = collection.toArray();
            switch (objectArray.length) {
                case 0: {
                    collection = isSet ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
                    break;
                }
                case 1: {
                    Object value = this.applyTo(objectArray[0]);
                    collection = isSet ? Collections.singleton(value) : Collections.singletonList(value);
                    break;
                }
                default: {
                    if (isSet) {
                        if (collection instanceof EnumSet) {
                            collection = Collections.unmodifiableSet(((EnumSet)collection).clone());
                            break;
                        }
                        if (collection instanceof CodeListSet) {
                            collection = Collections.unmodifiableSet(((CodeListSet)collection).clone());
                            break;
                        }
                        this.applyToAll(objectArray);
                        collection = CollectionsExt.immutableSet((boolean)false, (Object[])objectArray);
                        break;
                    }
                    this.applyToAll(objectArray);
                    collection = UnmodifiableArrayList.wrap((Object[])objectArray);
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap map = new LinkedHashMap((Map)object);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.applyTo(entry.getValue()));
            }
            return CollectionsExt.unmodifiableOrCopy(map);
        }
        if (object instanceof Cloneable) {
            if (this.cloner == null) {
                this.cloner = new Cloner(false);
            }
            return this.cloner.clone(object);
        }
        return object;
    }
}

