/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.gridded;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Optional;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 1638238437701248681L;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xSubsampling;
    private int ySubsampling;
    private AffineTransform gridToCRS;

    public Tile(Point location, Dimension subsampling) {
        this.x = location.x;
        this.y = location.y;
        this.setSubsampling(subsampling);
    }

    public Tile(Rectangle region, Dimension subsampling) {
        this.x = region.x;
        this.y = region.y;
        this.width = region.width;
        this.height = region.height;
        if (this.width <= 0 || this.height <= 0) {
            throw new IllegalArgumentException(Errors.format((short)44, (Object)"region"));
        }
        this.setSubsampling(subsampling);
    }

    public Tile(Rectangle region, AffineTransform gridToCRS) {
        ArgumentChecks.ensureNonNull((String)"gridToCRS", (Object)gridToCRS);
        if (region != null) {
            this.x = region.x;
            this.y = region.y;
            this.width = Math.max(region.width, 0);
            this.height = Math.max(region.height, 0);
        }
        this.gridToCRS = new AffineTransform(gridToCRS);
    }

    Tile(AffineTransform gridToCRS, Rectangle region) {
        this.x = region.x;
        this.y = region.y;
        this.width = region.width;
        this.height = region.height;
        this.gridToCRS = gridToCRS;
        this.setSubsampling(null);
    }

    private void ensureDefined() throws IllegalStateException {
        if (this.xSubsampling == 0 || this.ySubsampling == 0) {
            throw new IllegalStateException();
        }
    }

    public synchronized Point getLocation() throws IllegalStateException {
        this.ensureDefined();
        return new Point(this.x, this.y);
    }

    public synchronized Dimension getSize() throws IOException {
        if ((this.width | this.height) == 0) {
            Dimension size = this.fetchSize();
            this.width = size.width;
            this.height = size.height;
        }
        return new Dimension(this.width, this.height);
    }

    protected Dimension fetchSize() throws IOException {
        throw new IllegalStateException();
    }

    public synchronized Rectangle getRegion() throws IllegalStateException, IOException {
        this.ensureDefined();
        if ((this.width | this.height) == 0) {
            Dimension size = this.fetchSize();
            this.width = size.width;
            this.height = size.height;
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getRegionOnFinestLevel() throws IOException {
        int sy;
        int sx;
        Rectangle region;
        Tile tile = this;
        synchronized (tile) {
            region = this.getRegion();
            sx = this.xSubsampling;
            sy = this.ySubsampling;
        }
        region.x = Math.multiplyExact(region.x, sx);
        region.y = Math.multiplyExact(region.y, sy);
        region.width = Math.multiplyExact(region.width, sx);
        region.height = Math.multiplyExact(region.height, sy);
        return region;
    }

    final void setRegionOnFinestLevel(Rectangle region) throws ArithmeticException {
        assert (Thread.holdsLock(this));
        int sx = this.xSubsampling;
        int sy = this.ySubsampling;
        assert (region.width % sx == 0 && region.height % sy == 0) : region;
        this.x = region.x / sx;
        this.y = region.y / sy;
        this.width = region.width / sx;
        this.height = region.height / sy;
    }

    public synchronized Dimension getSubsampling() throws IllegalStateException {
        this.ensureDefined();
        return new Dimension(this.xSubsampling, this.ySubsampling);
    }

    final void setSubsampling(Dimension subsampling) throws IllegalStateException {
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            throw new IllegalStateException();
        }
        if (subsampling != null) {
            ArgumentChecks.ensureBetween((String)"width", (int)0, (int)65535, (int)subsampling.width);
            ArgumentChecks.ensureBetween((String)"height", (int)0, (int)65535, (int)subsampling.height);
            this.xSubsampling = subsampling.width;
            this.ySubsampling = subsampling.height;
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    final synchronized AffineTransform getPendingGridToCRS() {
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            return null;
        }
        AffineTransform at = this.gridToCRS;
        this.gridToCRS = null;
        return at;
    }

    public synchronized AffineTransform2D getGridToCRS() throws IllegalStateException {
        this.ensureDefined();
        return (AffineTransform2D)this.gridToCRS;
    }

    final void setGridToCRS(AffineTransform at) throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.gridToCRS == null) {
            this.gridToCRS = at;
        } else if (!this.gridToCRS.equals(at)) {
            throw new IllegalStateException();
        }
    }

    final void translate(int dx, int dy) {
        assert (Thread.holdsLock(this));
        this.x = Math.addExact(this.x, dx);
        this.y = Math.addExact(this.y, dy);
        this.gridToCRS = null;
    }

    public Optional<String> getName(boolean input) {
        return Optional.empty();
    }

    public int getImageIndex() {
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        if ((this.xSubsampling | this.ySubsampling) != 0) {
            buffer.append("location=(");
            if (this.width == 0 && this.height == 0) {
                Point location = this.getLocation();
                buffer.append(location.x).append(',').append(location.y);
            } else {
                try {
                    Rectangle region = this.getRegion();
                    buffer.append(region.x).append(',').append(region.y).append("), size=(").append(region.width).append(',').append(region.height);
                }
                catch (IOException e) {
                    buffer.append(e);
                }
            }
            Dimension subsampling = this.getSubsampling();
            buffer.append("), subsampling=(").append(subsampling.width).append(',').append(subsampling.height).append(')');
        } else if ((this.width != 0 || this.height != 0) && this.getClass() == Tile.class) {
            buffer.append("size=(").append(this.width).append(',').append(this.height).append(')');
        }
        return buffer.append(']').toString();
    }

    static String toString(Collection<Tile> tiles, int maximum) {
        StringWriter writer = new StringWriter();
        try {
            Tile.writeTable(tiles, writer, maximum);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return writer.toString();
    }

    public static void writeTable(Collection<Tile> tiles, Writer out, int maximum) throws IOException {
        int remaining = maximum;
        TableAppender table = new TableAppender((Appendable)out);
        table.setMultiLinesCells(false);
        table.nextLine('\u2550');
        table.append((CharSequence)"Format\tInput\tindex\tx\ty\twidth\theight\tdx\tdy\n");
        table.nextLine('\u2500');
        table.setMultiLinesCells(true);
        for (Tile tile : tiles) {
            if (--remaining < 0) break;
            table.setCellAlignment((byte)-1);
            tile.getName(false).ifPresent(arg_0 -> ((TableAppender)table).append(arg_0));
            table.nextColumn();
            tile.getName(true).ifPresent(arg_0 -> ((TableAppender)table).append(arg_0));
            table.nextColumn();
            table.setCellAlignment((byte)1);
            table.append((CharSequence)String.valueOf(tile.getImageIndex()));
            table.nextColumn();
            int x = tile.x;
            int y = tile.y;
            int width = tile.width;
            int height = tile.height;
            int xSubsampling = tile.xSubsampling;
            int ySubsampling = tile.ySubsampling;
            try {
                Dimension subsampling = tile.getSubsampling();
                xSubsampling = subsampling.width;
                ySubsampling = subsampling.height;
                try {
                    Rectangle region = tile.getRegion();
                    x = region.x;
                    y = region.y;
                    width = region.width;
                    height = region.height;
                }
                catch (IOException e) {
                    width = 0;
                    height = 0;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            table.append((CharSequence)String.valueOf(x));
            table.nextColumn();
            table.append((CharSequence)String.valueOf(y));
            if ((width | height) != 0) {
                table.nextColumn();
                table.append((CharSequence)String.valueOf(width));
                table.nextColumn();
                table.append((CharSequence)String.valueOf(height));
            } else {
                table.nextColumn();
                table.nextColumn();
            }
            if ((xSubsampling | ySubsampling) != 0) {
                table.nextColumn();
                table.append((CharSequence)String.valueOf(xSubsampling));
                table.nextColumn();
                table.append((CharSequence)String.valueOf(ySubsampling));
            }
            table.nextLine();
        }
        table.nextLine('\u2550');
        table.flush();
        if (remaining < 0) {
            out.write(Vocabulary.forLocale(null).getString((short)137, (Object)(tiles.size() - maximum)));
            out.write(System.lineSeparator());
        }
    }
}

