/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.factory.AuthorityFactoryIdentifier;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

abstract class AuthorityFactoryProxy<T> {
    final Class<T> type;
    final AuthorityFactoryIdentifier.Type factoryType;
    static final AuthorityFactoryProxy<IdentifiedObject> OBJECT = new AuthorityFactoryProxy<IdentifiedObject>(IdentifiedObject.class, AuthorityFactoryIdentifier.Type.ANY){

        @Override
        IdentifiedObject createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return factory.createObject(code);
        }
    };
    static final AuthorityFactoryProxy<DefaultDatumEnsemble<?>> ENSEMBLE = new AuthorityFactoryProxy<DefaultDatumEnsemble<?>>(DefaultDatumEnsemble.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        DefaultDatumEnsemble<?> create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createDatumEnsemble(code);
        }

        @Override
        DefaultDatumEnsemble<?> createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            if (factory instanceof GeodeticAuthorityFactory) {
                return ((GeodeticAuthorityFactory)factory).createDatumEnsemble(code);
            }
            throw new FactoryException("Unsupported factory.");
        }
    };
    static final AuthorityFactoryProxy<Datum> DATUM = new AuthorityFactoryProxy<Datum>(Datum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        Datum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createDatum(code);
        }

        @Override
        Datum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createDatum(code);
        }
    };
    static final AuthorityFactoryProxy<EngineeringDatum> ENGINEERING_DATUM = new AuthorityFactoryProxy<EngineeringDatum>(EngineeringDatum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        EngineeringDatum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createEngineeringDatum(code);
        }

        @Override
        EngineeringDatum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createEngineeringDatum(code);
        }
    };
    static final AuthorityFactoryProxy<ImageDatum> IMAGE_DATUM = new AuthorityFactoryProxy<ImageDatum>(ImageDatum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        ImageDatum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createImageDatum(code);
        }

        @Override
        ImageDatum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createImageDatum(code);
        }
    };
    static final AuthorityFactoryProxy<VerticalDatum> VERTICAL_DATUM = new AuthorityFactoryProxy<VerticalDatum>(VerticalDatum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        VerticalDatum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createVerticalDatum(code);
        }

        @Override
        VerticalDatum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createVerticalDatum(code);
        }
    };
    static final AuthorityFactoryProxy<TemporalDatum> TEMPORAL_DATUM = new AuthorityFactoryProxy<TemporalDatum>(TemporalDatum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        TemporalDatum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createTemporalDatum(code);
        }

        @Override
        TemporalDatum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createTemporalDatum(code);
        }
    };
    static final AuthorityFactoryProxy<GeodeticDatum> GEODETIC_DATUM = new AuthorityFactoryProxy<GeodeticDatum>(GeodeticDatum.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        GeodeticDatum create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createGeodeticDatum(code);
        }

        @Override
        GeodeticDatum createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createGeodeticDatum(code);
        }
    };
    static final AuthorityFactoryProxy<Ellipsoid> ELLIPSOID = new AuthorityFactoryProxy<Ellipsoid>(Ellipsoid.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        Ellipsoid create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createEllipsoid(code);
        }

        @Override
        Ellipsoid createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createEllipsoid(code);
        }
    };
    static final AuthorityFactoryProxy<PrimeMeridian> PRIME_MERIDIAN = new AuthorityFactoryProxy<PrimeMeridian>(PrimeMeridian.class, AuthorityFactoryIdentifier.Type.DATUM){

        @Override
        PrimeMeridian create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createPrimeMeridian(code);
        }

        @Override
        PrimeMeridian createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.datumFactory(factory).createPrimeMeridian(code);
        }
    };
    static final AuthorityFactoryProxy<Extent> EXTENT = new AuthorityFactoryProxy<Extent>(Extent.class, AuthorityFactoryIdentifier.Type.GEODETIC){

        @Override
        Extent create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createExtent(code);
        }

        @Override
        Extent createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.geodeticFactory(factory).createExtent(code);
        }
    };
    static final AuthorityFactoryProxy<CoordinateSystem> COORDINATE_SYSTEM = new AuthorityFactoryProxy<CoordinateSystem>(CoordinateSystem.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        CoordinateSystem create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCoordinateSystem(code);
        }

        @Override
        CoordinateSystem createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createCoordinateSystem(code);
        }
    };
    static final AuthorityFactoryProxy<CartesianCS> CARTESIAN_CS = new AuthorityFactoryProxy<CartesianCS>(CartesianCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        CartesianCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCartesianCS(code);
        }

        @Override
        CartesianCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createCartesianCS(code);
        }
    };
    static final AuthorityFactoryProxy<PolarCS> POLAR_CS = new AuthorityFactoryProxy<PolarCS>(PolarCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        PolarCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createPolarCS(code);
        }

        @Override
        PolarCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createPolarCS(code);
        }
    };
    static final AuthorityFactoryProxy<CylindricalCS> CYLINDRICAL_CS = new AuthorityFactoryProxy<CylindricalCS>(CylindricalCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        CylindricalCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCylindricalCS(code);
        }

        @Override
        CylindricalCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createCylindricalCS(code);
        }
    };
    static final AuthorityFactoryProxy<SphericalCS> SPHERICAL_CS = new AuthorityFactoryProxy<SphericalCS>(SphericalCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        SphericalCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createSphericalCS(code);
        }

        @Override
        SphericalCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createSphericalCS(code);
        }
    };
    static final AuthorityFactoryProxy<EllipsoidalCS> ELLIPSOIDAL_CS = new AuthorityFactoryProxy<EllipsoidalCS>(EllipsoidalCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        EllipsoidalCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createEllipsoidalCS(code);
        }

        @Override
        EllipsoidalCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createEllipsoidalCS(code);
        }
    };
    static final AuthorityFactoryProxy<VerticalCS> VERTICAL_CS = new AuthorityFactoryProxy<VerticalCS>(VerticalCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        VerticalCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createVerticalCS(code);
        }

        @Override
        VerticalCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createVerticalCS(code);
        }
    };
    static final AuthorityFactoryProxy<TimeCS> TIME_CS = new AuthorityFactoryProxy<TimeCS>(TimeCS.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        TimeCS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createTimeCS(code);
        }

        @Override
        TimeCS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createTimeCS(code);
        }
    };
    static final AuthorityFactoryProxy<CoordinateSystemAxis> AXIS = new AuthorityFactoryProxy<CoordinateSystemAxis>(CoordinateSystemAxis.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        CoordinateSystemAxis create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCoordinateSystemAxis(code);
        }

        @Override
        CoordinateSystemAxis createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createCoordinateSystemAxis(code);
        }
    };
    static final AuthorityFactoryProxy<Unit<?>> UNIT = new AuthorityFactoryProxy<Unit<?>>(Unit.class, AuthorityFactoryIdentifier.Type.CS){

        @Override
        Unit<?> create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createUnit(code);
        }

        @Override
        Unit<?> createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.csFactory(factory).createUnit(code);
        }
    };
    static final AuthorityFactoryProxy<CoordinateReferenceSystem> CRS = new AuthorityFactoryProxy<CoordinateReferenceSystem>(CoordinateReferenceSystem.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        CoordinateReferenceSystem create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCoordinateReferenceSystem(code);
        }

        @Override
        CoordinateReferenceSystem createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createCoordinateReferenceSystem(code);
        }
    };
    static final AuthorityFactoryProxy<CompoundCRS> COMPOUND_CRS = new AuthorityFactoryProxy<CompoundCRS>(CompoundCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        CompoundCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCompoundCRS(code);
        }

        @Override
        CompoundCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createCompoundCRS(code);
        }
    };
    static final AuthorityFactoryProxy<DerivedCRS> DERIVED_CRS = new AuthorityFactoryProxy<DerivedCRS>(DerivedCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        DerivedCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createDerivedCRS(code);
        }

        @Override
        DerivedCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createDerivedCRS(code);
        }
    };
    static final AuthorityFactoryProxy<EngineeringCRS> ENGINEERING_CRS = new AuthorityFactoryProxy<EngineeringCRS>(EngineeringCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        EngineeringCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createEngineeringCRS(code);
        }

        @Override
        EngineeringCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createEngineeringCRS(code);
        }
    };
    static final AuthorityFactoryProxy<GeographicCRS> GEOGRAPHIC_CRS = new AuthorityFactoryProxy<GeographicCRS>(GeographicCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        GeographicCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createGeographicCRS(code);
        }

        @Override
        GeographicCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createGeographicCRS(code);
        }
    };
    static final AuthorityFactoryProxy<GeocentricCRS> GEOCENTRIC_CRS = new AuthorityFactoryProxy<GeocentricCRS>(GeocentricCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        GeocentricCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createGeocentricCRS(code);
        }

        @Override
        GeocentricCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createGeocentricCRS(code);
        }
    };
    static final AuthorityFactoryProxy<ImageCRS> IMAGE_CRS = new AuthorityFactoryProxy<ImageCRS>(ImageCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        ImageCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createImageCRS(code);
        }

        @Override
        ImageCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createImageCRS(code);
        }
    };
    static final AuthorityFactoryProxy<ProjectedCRS> PROJECTED_CRS = new AuthorityFactoryProxy<ProjectedCRS>(ProjectedCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        ProjectedCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createProjectedCRS(code);
        }

        @Override
        ProjectedCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createProjectedCRS(code);
        }
    };
    static final AuthorityFactoryProxy<TemporalCRS> TEMPORAL_CRS = new AuthorityFactoryProxy<TemporalCRS>(TemporalCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        TemporalCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createTemporalCRS(code);
        }

        @Override
        TemporalCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createTemporalCRS(code);
        }
    };
    static final AuthorityFactoryProxy<VerticalCRS> VERTICAL_CRS = new AuthorityFactoryProxy<VerticalCRS>(VerticalCRS.class, AuthorityFactoryIdentifier.Type.CRS){

        @Override
        VerticalCRS create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createVerticalCRS(code);
        }

        @Override
        VerticalCRS createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.crsFactory(factory).createVerticalCRS(code);
        }
    };
    static final AuthorityFactoryProxy<ParameterDescriptor> PARAMETER = new AuthorityFactoryProxy<ParameterDescriptor>(ParameterDescriptor.class, AuthorityFactoryIdentifier.Type.GEODETIC){

        @Override
        ParameterDescriptor<?> create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createParameterDescriptor(code);
        }

        @Override
        ParameterDescriptor createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.geodeticFactory(factory).createParameterDescriptor(code);
        }
    };
    static final AuthorityFactoryProxy<OperationMethod> METHOD = new AuthorityFactoryProxy<OperationMethod>(OperationMethod.class, AuthorityFactoryIdentifier.Type.OPERATION){

        @Override
        OperationMethod create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createOperationMethod(code);
        }

        @Override
        OperationMethod createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.opFactory(factory).createOperationMethod(code);
        }
    };
    static final AuthorityFactoryProxy<CoordinateOperation> OPERATION = new AuthorityFactoryProxy<CoordinateOperation>(CoordinateOperation.class, AuthorityFactoryIdentifier.Type.OPERATION){

        @Override
        CoordinateOperation create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
            return factory.createCoordinateOperation(code);
        }

        @Override
        CoordinateOperation createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            return this.opFactory(factory).createCoordinateOperation(code);
        }
    };
    static final AuthorityFactoryProxy<?>[] PROXIES = new AuthorityFactoryProxy[]{PROJECTED_CRS, GEOGRAPHIC_CRS, GEOCENTRIC_CRS, VERTICAL_CRS, TEMPORAL_CRS, IMAGE_CRS, ENGINEERING_CRS, DERIVED_CRS, COMPOUND_CRS, CRS, GEODETIC_DATUM, VERTICAL_DATUM, TEMPORAL_DATUM, IMAGE_DATUM, ENGINEERING_DATUM, DATUM, ELLIPSOID, PRIME_MERIDIAN, CARTESIAN_CS, ELLIPSOIDAL_CS, SPHERICAL_CS, CYLINDRICAL_CS, POLAR_CS, VERTICAL_CS, TIME_CS, COORDINATE_SYSTEM, AXIS, OPERATION, METHOD, PARAMETER, UNIT, EXTENT, OBJECT};
    private static final Map<String, AuthorityFactoryProxy<?>> BY_URN_TYPE = Map.ofEntries(Map.entry("crs", CRS), Map.entry("crs-compound", CRS), Map.entry("datum", DATUM), Map.entry("ellipsoid", ELLIPSOID), Map.entry("meridian", PRIME_MERIDIAN), Map.entry("cs", COORDINATE_SYSTEM), Map.entry("axis", AXIS), Map.entry("coordinateoperation", OPERATION), Map.entry("method", METHOD), Map.entry("parameter", PARAMETER), Map.entry("referencesystem", CRS), Map.entry("uom", UNIT));

    AuthorityFactoryProxy(Class<T> type, AuthorityFactoryIdentifier.Type factoryType) {
        this.type = type;
        this.factoryType = factoryType;
    }

    public String toString() {
        return Strings.bracket(AuthorityFactoryProxy.class, (Object)this.type.getSimpleName());
    }

    final DatumAuthorityFactory datumFactory(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof DatumAuthorityFactory) {
            return (DatumAuthorityFactory)factory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(DatumAuthorityFactory.class);
    }

    final CSAuthorityFactory csFactory(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof CSAuthorityFactory) {
            return (CSAuthorityFactory)factory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CSAuthorityFactory.class);
    }

    final CRSAuthorityFactory crsFactory(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof CRSAuthorityFactory) {
            return (CRSAuthorityFactory)factory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CRSAuthorityFactory.class);
    }

    final CoordinateOperationAuthorityFactory opFactory(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)factory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(CoordinateOperationAuthorityFactory.class);
    }

    final GeodeticAuthorityFactory geodeticFactory(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof CRSAuthorityFactory) {
            return (GeodeticAuthorityFactory)factory;
        }
        throw AuthorityFactoryProxy.factoryNotFound(GeodeticAuthorityFactory.class);
    }

    private static FactoryException factoryNotFound(Class<? extends AuthorityFactory> type) {
        return new FactoryException(Errors.format((short)51, type));
    }

    T create(GeodeticAuthorityFactory factory, String code) throws FactoryException {
        return this.createFromAPI(factory, code);
    }

    abstract T createFromAPI(AuthorityFactory var1, String var2) throws FactoryException;

    static <T> AuthorityFactoryProxy<? super T> getInstance(Class<T> type) throws IllegalArgumentException {
        for (AuthorityFactoryProxy<?> proxy : PROXIES) {
            if (!proxy.type.isAssignableFrom(type)) continue;
            return proxy;
        }
        throw new IllegalArgumentException(Errors.format((short)64, IdentifiedObject.class, type));
    }

    AuthorityFactoryProxy<? extends T> specialize(String typeName) {
        AuthorityFactoryProxy<?> c = BY_URN_TYPE.get(typeName.toLowerCase(Locale.US));
        if (c != null) {
            if (c.type.isAssignableFrom(this.type)) {
                return this;
            }
            if (this.type.isAssignableFrom(c.type)) {
                return c;
            }
        }
        return null;
    }

    static final class Description
    extends AuthorityFactoryProxy<InternationalString> {
        private Class<? extends IdentifiedObject> typeToSearch;

        Description(Class<? extends IdentifiedObject> typeToSearch) {
            super(InternationalString.class, AuthorityFactoryIdentifier.Type.ANY);
            this.typeToSearch = typeToSearch;
        }

        @Override
        InternationalString createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            if (factory instanceof GeodeticAuthorityFactory) {
                return ((GeodeticAuthorityFactory)factory).getDescriptionText(this.typeToSearch, code).orElse(null);
            }
            return factory.getDescriptionText(code);
        }

        @Override
        AuthorityFactoryProxy<InternationalString> specialize(String typeName) {
            AuthorityFactoryProxy<?> c = BY_URN_TYPE.get(typeName.toLowerCase(Locale.US));
            if (c != null && this.typeToSearch.isAssignableFrom(c.type)) {
                this.typeToSearch = c.type.asSubclass(IdentifiedObject.class);
                return this;
            }
            return null;
        }
    }
}

