/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;

public final class DatumOrEnsemble
extends Static {
    private static final String ENSEMBLE = "ensemble";
    private final Datum datum;
    private final DefaultDatumEnsemble<?> ensemble;
    private final ComparisonMode mode;

    private DatumOrEnsemble(Datum datum, DefaultDatumEnsemble<?> ensemble, ComparisonMode mode) {
        this.datum = datum;
        this.ensemble = ensemble;
        this.mode = mode;
    }

    public static IdentifiedObject of(SingleCRS crs) {
        if (crs == null) {
            return null;
        }
        Datum datum = crs.getDatum();
        return datum != null ? datum : DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)crs);
    }

    private static DefaultDatumEnsemble getDatumEnsemble(CoordinateReferenceSystem crs) {
        try {
            Object ensemble = crs.getClass().getMethod("getDatumEnsemble", null).invoke((Object)crs, (Object[])null);
            if (ensemble instanceof DefaultDatumEnsemble) {
                return (DefaultDatumEnsemble)ensemble;
            }
        }
        catch (ReflectiveOperationException e) {
            Logging.ignorableException((Logger)Logger.getLogger("org.apache.sis.referencing"), DatumOrEnsemble.class, (String)"getDatumEnsemble", (Throwable)e);
        }
        return null;
    }

    public static Optional<IdentifiedObject> ofTarget(SingleCRS source, SingleCRS target) {
        return DatumOrEnsemble.asTargetDatum(source, source.getDatum(), target, target.getDatum(), ensemble -> ensemble);
    }

    public static GeodeticDatum asDatum(GeodeticCRS crs) {
        if (crs == null) {
            return null;
        }
        GeodeticDatum datum = crs.getDatum();
        return datum != null ? datum : DefaultDatumEnsemble.Geodetic.datum(DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)crs));
    }

    public static VerticalDatum asDatum(VerticalCRS crs) {
        if (crs == null) {
            return null;
        }
        VerticalDatum datum = crs.getDatum();
        return datum != null ? datum : DefaultDatumEnsemble.Vertical.datum(DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)crs));
    }

    public static TemporalDatum asDatum(TemporalCRS crs) {
        if (crs == null) {
            return null;
        }
        TemporalDatum datum = crs.getDatum();
        return datum != null ? datum : DefaultDatumEnsemble.Time.datum(DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)crs));
    }

    public static EngineeringDatum asDatum(EngineeringCRS crs) {
        if (crs == null) {
            return null;
        }
        EngineeringDatum datum = crs.getDatum();
        return datum != null ? datum : DefaultDatumEnsemble.Engineering.datum(DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)crs));
    }

    public static Optional<GeodeticDatum> asTargetDatum(GeodeticCRS source, GeodeticCRS target) {
        return DatumOrEnsemble.asTargetDatum(source, source.getDatum(), target, target.getDatum(), DefaultDatumEnsemble.Geodetic::datum);
    }

    public static Optional<VerticalDatum> asTargetDatum(VerticalCRS source, VerticalCRS target) {
        return DatumOrEnsemble.asTargetDatum(source, source.getDatum(), target, target.getDatum(), DefaultDatumEnsemble.Vertical::datum);
    }

    public static Optional<TemporalDatum> asTargetDatum(TemporalCRS source, TemporalCRS target) {
        return DatumOrEnsemble.asTargetDatum(source, source.getDatum(), target, target.getDatum(), DefaultDatumEnsemble.Time::datum);
    }

    public static Optional<EngineeringDatum> asTargetDatum(EngineeringCRS source, EngineeringCRS target) {
        return DatumOrEnsemble.asTargetDatum(source, source.getDatum(), target, target.getDatum(), DefaultDatumEnsemble.Engineering::datum);
    }

    private static <C extends SingleCRS, D extends Datum, R extends IdentifiedObject> Optional<R> asTargetDatum(C sourceCRS, R sourceDatum, C targetCRS, R targetDatum, Function<DefaultDatumEnsemble<D>, R> constructor) {
        DefaultDatumEnsemble sourceEnsemble;
        DefaultDatumEnsemble selected;
        DefaultDatumEnsemble targetEnsemble;
        block9: {
            block8: {
                if (sourceDatum != null && Utilities.equalsIgnoreMetadata(sourceDatum, targetDatum)) {
                    return Optional.of(targetDatum);
                }
                selected = targetEnsemble = DatumOrEnsemble.getDatumEnsemble(targetCRS);
                if (DatumOrEnsemble.isMember(targetEnsemble, sourceDatum)) break block8;
                selected = sourceEnsemble = DatumOrEnsemble.getDatumEnsemble(sourceCRS);
                if (!DatumOrEnsemble.isMember(sourceEnsemble, targetDatum) && (sourceEnsemble == null || sourceEnsemble != targetEnsemble)) break block9;
            }
            return Optional.of((IdentifiedObject)constructor.apply(selected));
        }
        if (sourceEnsemble != null && targetEnsemble != null) {
            selected = targetEnsemble;
            Collection large = targetEnsemble.getMembers();
            Collection small = sourceEnsemble.getMembers();
            if (small.size() > large.size()) {
                selected = sourceEnsemble;
                Collection t = large;
                large = small;
                small = t;
            }
            small = new ArrayDeque(small);
            block0: for (Datum member : large) {
                Iterator it = small.iterator();
                while (it.hasNext()) {
                    if (!Utilities.equalsIgnoreMetadata((Object)member, it.next())) continue;
                    it.remove();
                    if (!small.isEmpty()) continue block0;
                    return Optional.of((IdentifiedObject)constructor.apply(selected));
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isMember(DefaultDatumEnsemble<?> ensemble, IdentifiedObject datum) {
        if (ensemble != null && datum != null) {
            for (Datum member : ensemble.getMembers()) {
                if (!Utilities.equalsIgnoreMetadata((Object)datum, (Object)member)) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<DefaultDatumEnsemble<GeodeticDatum>> asEnsemble(GeodeticDatum datum) {
        if (datum instanceof DefaultDatumEnsemble.Geodetic) {
            return Optional.of((DefaultDatumEnsemble.Geodetic)datum);
        }
        return Optional.empty();
    }

    public static Optional<DefaultDatumEnsemble<VerticalDatum>> asEnsemble(VerticalDatum datum) {
        if (datum instanceof DefaultDatumEnsemble.Vertical) {
            return Optional.of((DefaultDatumEnsemble.Vertical)datum);
        }
        return Optional.empty();
    }

    public static Optional<DefaultDatumEnsemble<TemporalDatum>> asEnsemble(TemporalDatum datum) {
        if (datum instanceof DefaultDatumEnsemble.Time) {
            return Optional.of((DefaultDatumEnsemble.Time)datum);
        }
        return Optional.empty();
    }

    public static Optional<DefaultDatumEnsemble<EngineeringDatum>> asEnsemble(EngineeringDatum datum) {
        if (datum instanceof DefaultDatumEnsemble.Engineering) {
            return Optional.of((DefaultDatumEnsemble.Engineering)datum);
        }
        return Optional.empty();
    }

    public static boolean isLegacyDatum(DefaultDatumEnsemble<?> ensemble, Datum datum, ComparisonMode mode) {
        int i;
        if (ensemble == null || datum == null) {
            return false;
        }
        if (ensemble == datum) {
            return true;
        }
        DatumOrEnsemble c = new DatumOrEnsemble(datum, ensemble, mode);
        if (!(c.isPropertyEqual(GeodeticDatum.class, GeodeticDatum::getEllipsoid, Objects::nonNull) && c.isPropertyEqual(GeodeticDatum.class, GeodeticDatum::getPrimeMeridian, Objects::nonNull) && c.isPropertyEqual(VerticalDatum.class, VerticalDatum::getVerticalDatumType, Objects::nonNull))) {
            return false;
        }
        Boolean match = Identifiers.hasCommonIdentifier(ensemble.getIdentifiers(), (Iterable)datum.getIdentifiers());
        if (match != null) {
            return match;
        }
        if (IdentifiedObjects.isHeuristicMatchForName(ensemble, datum.getName().getCode())) {
            return true;
        }
        String name = ensemble.getName().getCode();
        if (name.endsWith(ENSEMBLE) && (i = name.length() - ENSEMBLE.length()) > (i = CharSequences.skipTrailingWhitespaces((CharSequence)name, (int)0, (int)i))) {
            name = name.substring(0, i);
        }
        return IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)datum, name);
    }

    public static Optional<Ellipsoid> getEllipsoid(CoordinateReferenceSystem crs) {
        return Optional.ofNullable(DatumOrEnsemble.getProperty(crs, GeodeticDatum.class, GeodeticDatum::getEllipsoid, Objects::nonNull));
    }

    public static Optional<PrimeMeridian> getPrimeMeridian(CoordinateReferenceSystem crs) {
        return Optional.ofNullable(DatumOrEnsemble.getProperty(crs, GeodeticDatum.class, GeodeticDatum::getPrimeMeridian, Objects::nonNull));
    }

    private static <P, D extends Datum> P getProperty(CoordinateReferenceSystem crs, Class<D> datumType, Function<D, P> getter, Predicate<P> nonNull) {
        if (crs instanceof SingleCRS) {
            P property;
            SingleCRS scrs = (SingleCRS)crs;
            Datum datum = scrs.getDatum();
            if (datumType.isInstance(datum) && nonNull.test(property = getter.apply(datum))) {
                return property;
            }
            DatumOrEnsemble c = new DatumOrEnsemble(datum, DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)scrs), ComparisonMode.IGNORE_METADATA);
            return c.getEnsembleProperty(null, datumType, getter, nonNull);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem c : ((CompoundCRS)crs).getComponents()) {
                P property = DatumOrEnsemble.getProperty(c, datumType, getter, nonNull);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }

    private <P, D extends Datum> P getEnsembleProperty(P common, Class<D> datumType, Function<D, P> getter, Predicate<P> nonNull) {
        boolean searching;
        boolean bl = searching = common != null;
        if (this.ensemble != null) {
            for (Datum member : this.ensemble.getMembers()) {
                P property;
                if (!datumType.isInstance(member) || !nonNull.test(property = getter.apply(member))) continue;
                if (common == null) {
                    common = property;
                    continue;
                }
                if (Utilities.deepEquals(property, common, (ComparisonMode)this.mode) != searching) continue;
                return (P)(searching ? common : null);
            }
        }
        return searching ? null : (P)common;
    }

    private <P, D extends Datum> boolean isPropertyEqual(Class<D> datumType, Function<D, P> getter, Predicate<P> nonNull) {
        Object property = null;
        if (datumType.isInstance(this.datum) && !nonNull.test(property = (Object)getter.apply(this.datum))) {
            return true;
        }
        return this.getEnsembleProperty(property, datumType, getter, nonNull) == property;
    }

    public static Optional<PositionalAccuracy> getAccuracy(IdentifiedObject object) {
        DefaultDatumEnsemble ensemble;
        if (object instanceof DefaultDatumEnsemble) {
            ensemble = (DefaultDatumEnsemble)object;
        } else if (object instanceof SingleCRS) {
            ensemble = DatumOrEnsemble.getDatumEnsemble((CoordinateReferenceSystem)((SingleCRS)object));
            if (ensemble == null) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        return Optional.of(ensemble.getEnsembleAccuracy());
    }
}

