/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import org.apache.sis.metadata.iso.citation.Citations;
import org.opengis.metadata.citation.Citation;

public enum Convention {
    WKT2(true),
    WKT2_SIMPLIFIED(false),
    WKT2_2019(true),
    WKT2_2015(true),
    WKT1(true),
    WKT1_COMMON_UNITS(true),
    WKT1_IGNORE_AXES(true),
    INTERNAL(false);

    static final Convention DEFAULT;
    final boolean toUpperCase;

    private Convention(boolean toUpperCase) {
        this.toUpperCase = toUpperCase;
    }

    public boolean supports(Convention base) {
        return this.compareTo(base) <= 0 || this == INTERNAL;
    }

    public int majorVersion() {
        return this.supports(WKT2_2015) ? 2 : 1;
    }

    public boolean isSimplified() {
        return this == WKT2_SIMPLIFIED || this.ordinal() >= WKT1.ordinal();
    }

    final boolean usesCommonUnits() {
        return this == WKT1_COMMON_UNITS || this == WKT1_IGNORE_AXES;
    }

    final Citation getNameAuthority() {
        return this.majorVersion() == 1 ? Citations.OGC : Citations.EPSG;
    }

    static {
        DEFAULT = WKT2;
    }
}

