/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.sis.geometry.wrapper.AbstractGeometry;
import org.apache.sis.referencing.internal.shared.IntervalRectangle;

public abstract class FlatShape
extends AbstractGeometry
implements Shape {
    final IntervalRectangle bounds;

    FlatShape(IntervalRectangle bounds) {
        this.bounds = bounds;
    }

    FlatShape(double[] coordinates, int size) {
        double ymax;
        double xmax;
        double xmin = xmax = coordinates[0];
        double ymin = ymax = coordinates[1];
        int i = 2;
        while (i < size) {
            double x = coordinates[i++];
            double y = coordinates[i++];
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        this.bounds = new IntervalRectangle(xmin, ymin, xmax, ymax);
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D() {
        return this.bounds.getBounds2D();
    }

    @Override
    public final boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public FlatShape fastClip(Rectangle2D areaOfInterest) {
        return this.bounds.intersects(areaOfInterest) ? this : null;
    }
}

