/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.internal.GeometryConverter;
import org.apache.sis.filter.internal.shared.WarningEvent;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -749201100175374658L;
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.filter");
    private static final LocalName SCOPE = Names.createLocalName((CharSequence)"Apache", null, (CharSequence)"sis");
    private static final Set<FunctionProperty> TRANSITIVE_PROPERTIES = Set.of(FunctionProperty.VOLATILE);

    protected Node() {
    }

    protected static <T> DefaultAttributeType<T> createType(Class<T> type, Object name) {
        return new DefaultAttributeType<Object>(Collections.singletonMap("name", name), type, 1, 1, null, null);
    }

    protected static <R> Class<? super R> specializedClass(Class<? super R> t1, Class<? super R> t2) {
        if (t1 != null && t2 != null) {
            if (t1.isAssignableFrom(t2)) {
                return t2;
            }
            if (t2.isAssignableFrom(t1)) {
                return t1;
            }
        }
        return null;
    }

    protected char symbol() {
        return '\u0000';
    }

    public final Object getDisplayName() {
        if (this instanceof Expression) {
            return ((Expression)((Object)this)).getFunctionName();
        }
        if (this instanceof Filter) {
            return ((Filter)((Object)this)).getOperatorType();
        }
        return this.getClass().getSimpleName();
    }

    protected static ScopedName createName(String tip) {
        return Names.createScopedName((GenericName)SCOPE, null, (CharSequence)tip);
    }

    protected static <R, G> Expression<R, GeometryWrapper> toGeometryWrapper(Geometries<G> library, Expression<R, ?> expression) {
        return GeometryConverter.create(library, expression);
    }

    protected static <R> Expression<R, ?> unwrap(Expression<R, GeometryWrapper> expression) {
        if (expression instanceof GeometryConverter) {
            return ((GeometryConverter)expression).expression;
        }
        return expression;
    }

    protected static Geometries<?> getGeometryLibrary(Expression<?, GeometryWrapper> expression) {
        if (expression instanceof GeometryConverter) {
            return ((GeometryConverter)expression).library;
        }
        throw new IllegalArgumentException(Resources.format((short)52));
    }

    private static boolean isVolatile(Set<FunctionProperty> properties) {
        return properties.contains(FunctionProperty.VOLATILE);
    }

    private static <R> boolean isVolatile(Iterable<Expression<R, ?>> operands) {
        for (Expression<R, ?> operand : operands) {
            if (!(operand instanceof FeatureExpression ? Node.isVolatile(((FeatureExpression)operand).properties()) : Node.isVolatile(operand.getParameters()))) continue;
            return true;
        }
        return false;
    }

    public static Set<FunctionProperty> properties(Expression<?, ?> function) {
        if (function instanceof FeatureExpression) {
            return ((FeatureExpression)function).properties();
        }
        if (function != null) {
            return Node.transitiveProperties(function.getParameters());
        }
        return Set.of();
    }

    public static <R> Set<FunctionProperty> transitiveProperties(Iterable<Expression<R, ?>> operands) {
        return Node.isVolatile(operands) ? TRANSITIVE_PROPERTIES : Set.of();
    }

    protected abstract Collection<?> getChildren();

    private void toTree(TreeTable.Node root, Map<Object, Boolean> visited) {
        root.setValue(TableColumn.VALUE, this.getDisplayName());
        for (Object child : this.getChildren()) {
            Object value;
            TreeTable.Node node = root.newChild();
            if (child instanceof Node) {
                if (visited.putIfAbsent(child, Boolean.TRUE) == null) {
                    ((Node)child).toTree(node, visited);
                    continue;
                }
                value = Vocabulary.format((short)46);
            } else if (child instanceof IdentifiedObject) {
                IdentifiedObject object = (IdentifiedObject)child;
                value = Classes.getShortName((Class)ReferencingUtilities.getInterface((Object)object)) + "[\u201c" + IdentifiedObjects.getDisplayName((IdentifiedObject)object, null) + "\u201d]";
            } else {
                value = String.valueOf(child);
            }
            node.setValue(TableColumn.VALUE, value);
        }
    }

    public final String toString() {
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{TableColumn.VALUE});
        this.toTree(table.getRoot(), new IdentityHashMap<Object, Boolean>());
        return table.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() + 37 * this.getChildren().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            return this.getChildren().equals(((Node)other).getChildren());
        }
        return false;
    }

    protected final void warning(Exception exception, boolean recoverable) {
        Consumer<WarningEvent> listener = WarningEvent.LISTENER.get();
        if (listener != null) {
            listener.accept(new WarningEvent(this, exception));
        } else {
            String method;
            String string = method = this instanceof Predicate ? "test" : "apply";
            if (recoverable) {
                Logging.recoverableException((Logger)LOGGER, this.getClass(), (String)method, (Throwable)exception);
            } else {
                Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)method, (Throwable)exception);
            }
        }
    }
}

