/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.xml.NilReason;

class UnaryFunction<R, V>
extends Node {
    private static final long serialVersionUID = 2020526901451551162L;
    protected final Expression<R, ? extends V> expression;

    UnaryFunction(Expression<R, ? extends V> expression) {
        this.expression = Objects.requireNonNull(expression);
    }

    public final Class<? super R> getResourceClass() {
        return this.expression.getResourceClass();
    }

    public final List<Expression<R, ?>> getParameters() {
        return this.getExpressions();
    }

    public final List<Expression<R, ?>> getExpressions() {
        return List.of(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    static final class IsNil<R>
    extends UnaryFunction<R, Object>
    implements Filter<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -7540765433296725888L;
        private final String nilReason;

        IsNil(Expression<R, ?> expression, String nilReason) {
            super(expression);
            this.nilReason = nilReason;
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NIL;
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new IsNil<R>(effective[0], this.nilReason);
        }

        public Optional<String> getNilReason() {
            return Optional.ofNullable(this.nilReason);
        }

        @Override
        public boolean test(R object) {
            NilReason value = NilReason.forObject(this.expression.apply(object));
            if (value == null) {
                return false;
            }
            if (this.nilReason == null) {
                return true;
            }
            String explanation = value.equals((Object)NilReason.OTHER) ? value.getOtherExplanation() : value.toString();
            return this.nilReason.equalsIgnoreCase(explanation);
        }
    }

    static final class IsNull<R>
    extends UnaryFunction<R, Object>
    implements Filter<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = 2960285515924533419L;

        IsNull(Expression<R, ?> expression) {
            super(expression);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NULL;
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new IsNull<R>(effective[0]);
        }

        @Override
        protected char symbol() {
            return '\u2205';
        }

        @Override
        public boolean test(R object) {
            return this.expression.apply(object) == null;
        }
    }
}

