/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.AssociationValue;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.shared.XPath;
import org.apache.sis.pending.geoapi.filter.Name;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

abstract class PropertyValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
Optimization.OnExpression<AbstractFeature, V> {
    private static final long serialVersionUID = 3756361632664536269L;
    protected final String name;
    protected final boolean isVirtual;
    private static final String VIRTUAL_PREFIX = "/*/";

    protected PropertyValue(String name, boolean isVirtual) {
        this.name = name;
        this.isVirtual = isVirtual;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    static <V> ValueReference<AbstractFeature, V> create(String xpath, Class<V> type) {
        XPath parsed = new XPath(xpath);
        List<String> path = parsed.path;
        boolean isVirtual = false;
        if (parsed.isAbsolute) {
            boolean bl = isVirtual = path != null && path.get(0).equals("*");
            if (!isVirtual) {
                throw new IllegalArgumentException(Errors.format((short)201, (Object)xpath));
            }
            path.remove(0);
            if (path.isEmpty()) {
                path = null;
            }
        }
        PropertyValue tip = type != Object.class ? new Converted<V>(type, parsed.tip, isVirtual) : new AsObject(parsed.tip, isVirtual);
        return path != null ? new AssociationValue<Object>(path, tip) : tip;
    }

    @Override
    public final Class<AbstractFeature> getResourceClass() {
        return AbstractFeature.class;
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.isVirtual ? List.of(this.name, Boolean.valueOf(this.isVirtual)) : List.of(this.name);
    }

    @Override
    public final String getXPath() {
        return this.getXPath(null);
    }

    final String getXPath(String[] path) {
        return XPath.toString(this.isVirtual ? VIRTUAL_PREFIX : null, path, this.name);
    }

    protected Class<?> getSourceClass() {
        return Object.class;
    }

    final FeatureProjectionBuilder.Item defaultType(FeatureProjectionBuilder addTo) {
        return addTo.addComputedProperty(((AttributeTypeBuilder)addTo.addAttribute(this.getValueClass()).setMinimumOccurs(0)).setName((CharSequence)this.name), true);
    }

    public final <N> PropertyValue<N> toValueType(Class<N> target) {
        if (target.equals(this.getValueClass())) {
            return this;
        }
        Class<?> source = this.getSourceClass();
        if (target == Object.class) {
            return new AsObject(this.name, this.isVirtual);
        }
        if (source == Object.class) {
            return new Converted<N>(target, this.name, this.isVirtual);
        }
        return new CastedAndConverted(source, target, this.name, this.isVirtual);
    }

    public abstract PropertyValue<V> optimize(Optimization var1);

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        AbstractIdentifiedType type;
        try {
            type = addTo.source().getProperty(this.name);
        }
        catch (IllegalArgumentException e) {
            if (this.isVirtual) {
                return this.defaultType(addTo);
            }
            throw e;
        }
        return addTo.addSourceProperty(type, true);
    }

    private static class Converted<V>
    extends PropertyValue<V> {
        private static final long serialVersionUID = -1436865010478207066L;
        protected final Class<V> type;

        protected Converted(Class<V> type, String xpath, boolean isVirtual) {
            super(xpath, isVirtual);
            this.type = type;
        }

        @Override
        public final Class<V> getValueClass() {
            return this.type;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return (V)ObjectConverters.convert((Object)instance.getValueOrFallback(this.name, null), this.type);
                }
                catch (UnconvertibleObjectException e) {
                    this.warning((Exception)((Object)e), false);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return null;
        }

        @Override
        public final PropertyValue<V> optimize(Optimization optimization) {
            DefaultFeatureType featureType = optimization.getFeatureType();
            if (featureType != null) {
                try {
                    String rename = this.name;
                    AbstractIdentifiedType property = featureType.getProperty(rename);
                    Optional<String> target = Features.getLinkTarget(property);
                    if (target.isPresent()) {
                        try {
                            rename = target.get();
                            property = featureType.getProperty(rename);
                        }
                        catch (IllegalArgumentException e) {
                            this.warning(e, true);
                            rename = this.name;
                        }
                    }
                    Class<Object> source = this.getSourceClass();
                    Class<?> original = source;
                    if (property instanceof DefaultAttributeType) {
                        source = ((DefaultAttributeType)property).getValueClass();
                    }
                    if (!rename.equals(this.name) || !source.equals(original)) {
                        if (source == Object.class) {
                            return new Converted<V>(this.type, rename, this.isVirtual);
                        }
                        return new CastedAndConverted<Object, V>(source, this.type, rename, this.isVirtual);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return this;
        }

        @Override
        public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
            FeatureProjectionBuilder.Item item = super.expectedType(addTo);
            item.replaceValueClass(c -> this.type.isAssignableFrom((Class<?>)c) ? c : this.type);
            return item;
        }
    }

    private static final class AsObject
    extends PropertyValue<Object> {
        private static final long serialVersionUID = 2854731969723006038L;

        AsObject(String name, boolean isVirtual) {
            super(name, isVirtual);
        }

        @Override
        public Object apply(AbstractFeature instance) {
            return instance != null ? instance.getValueOrFallback(this.name, null) : null;
        }

        @Override
        public PropertyValue<Object> optimize(Optimization optimization) {
            DefaultFeatureType type = optimization.getFeatureType();
            if (type != null) {
                try {
                    return Features.getLinkTarget(type.getProperty(this.name)).map(rename -> new AsObject((String)rename, this.isVirtual)).orElse(this);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return this;
        }
    }

    private static final class CastedAndConverted<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -58453954752151703L;
        private final Class<S> source;
        private final ObjectConverter<? super S, ? extends V> converter;

        CastedAndConverted(Class<S> source, Class<V> type, String xpath, boolean isVirtual) {
            super(type, xpath, isVirtual);
            this.source = source;
            this.converter = ObjectConverters.find(source, type);
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return (V)this.converter.apply(this.source.cast(instance.getValueOrFallback(this.name, null)));
                }
                catch (ClassCastException | UnconvertibleObjectException e) {
                    this.warning((Exception)e, false);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return null;
        }
    }
}

