/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.shared.AbstractMap;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

final class CharacteristicTypeMap
extends AbstractMap<String, DefaultAttributeType<?>> {
    private static final WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> SHARED = new WeakValueHashMap(DefaultAttributeType[].class);
    final DefaultAttributeType<?>[] characterizedBy;
    final Map<String, Integer> indices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacteristicTypeMap create(DefaultAttributeType<?> source, DefaultAttributeType<?>[] characterizedBy) {
        CharacteristicTypeMap map;
        WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> weakValueHashMap = SHARED;
        synchronized (weakValueHashMap) {
            map = (CharacteristicTypeMap)((Object)SHARED.get(characterizedBy));
            if (map == null) {
                map = new CharacteristicTypeMap(source, characterizedBy);
                SHARED.put(characterizedBy, (Object)map);
            }
        }
        return map;
    }

    private CharacteristicTypeMap(DefaultAttributeType<?> source, DefaultAttributeType<?>[] characterizedBy) {
        this.characterizedBy = characterizedBy;
        int index = 0;
        HashMap indices = JDK19.newHashMap((int)characterizedBy.length);
        HashMap<String, Integer> aliases = new HashMap<String, Integer>();
        for (int i = 0; i < characterizedBy.length; ++i) {
            DefaultAttributeType<?> attribute = characterizedBy[i];
            ArgumentChecks.ensureNonNullElement((String)"characterizedBy", (int)i, attribute);
            GenericName name = attribute.getName();
            String key = AbstractIdentifiedType.toString(name, source, "characterizedBy", i);
            Integer value = index++;
            if (indices.put(key, value) != null) {
                throw new IllegalArgumentException(Errors.format((short)39, (Object)key));
            }
            while (name instanceof ScopedName && name != (name = ((ScopedName)name).tail()) && (key = name.toString()) != null && !(key = key.trim()).isEmpty()) {
                if (aliases.put(key, value) == null) continue;
                aliases.put(key, -1);
            }
        }
        for (Map.Entry entry : aliases.entrySet()) {
            Integer value = (Integer)entry.getValue();
            if (value < 0) continue;
            indices.putIfAbsent((String)entry.getKey(), value);
        }
        this.indices = CollectionsExt.compact((Map)indices);
    }

    public boolean isEmpty() {
        return this.characterizedBy.length == 0;
    }

    public int size() {
        return this.characterizedBy.length;
    }

    public boolean containsKey(Object key) {
        return this.indices.containsKey(key);
    }

    public boolean containsValue(Object key) {
        for (DefaultAttributeType<?> type : this.characterizedBy) {
            if (!type.equals(key)) continue;
            return true;
        }
        return false;
    }

    public DefaultAttributeType<?> get(Object key) {
        Integer index = this.indices.get(key);
        return index != null ? this.characterizedBy[index] : null;
    }

    protected AbstractMap.EntryIterator<String, DefaultAttributeType<?>> entryIterator() {
        return new AbstractMap.EntryIterator<String, DefaultAttributeType<?>>(){
            private int index;
            private DefaultAttributeType<?> value;

            protected boolean next() {
                if (this.index < CharacteristicTypeMap.this.characterizedBy.length) {
                    this.value = CharacteristicTypeMap.this.characterizedBy[this.index++];
                    return true;
                }
                return false;
            }

            protected String getKey() {
                return this.value.getName().toString();
            }

            protected DefaultAttributeType<?> getValue() {
                return this.value;
            }
        };
    }
}

