/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.internal.shared.EmptyQueue;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.util.CodeList;

public final class CollectionsExt {
    private CollectionsExt() {
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.INSTANCE;
    }

    public static Collection<?> empty(Class<?> type) {
        if (type.isAssignableFrom(List.class)) {
            return Collections.EMPTY_LIST;
        }
        if (type.isAssignableFrom(Set.class)) {
            return Collections.EMPTY_SET;
        }
        if (type.isAssignableFrom(NavigableSet.class)) {
            if (type.isAssignableFrom(SortedSet.class)) {
                return Collections.emptySortedSet();
            }
            return Collections.emptyNavigableSet();
        }
        if (type.isAssignableFrom(Queue.class)) {
            return CollectionsExt.emptyQueue();
        }
        return null;
    }

    public static int size(Object c) {
        if (c == null) {
            return 0;
        }
        if (c instanceof Collection) {
            return ((Collection)c).size();
        }
        if (c instanceof Map) {
            return ((Map)c).size();
        }
        return 1;
    }

    public static <T> T first(Iterable<T> collection) {
        Iterator<T> it;
        if (collection != null && (it = collection.iterator()) != null && it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static <T> T lastNonNull(List<T> collection) {
        if (collection != null) {
            int i = collection.size();
            while (--i >= 0) {
                T e = collection.get(i);
                if (e == null) continue;
                return e;
            }
        }
        return null;
    }

    public static <T> T singletonOrNull(Iterable<T> collection) {
        Iterator<T> it;
        if (collection != null && (it = collection.iterator()) != null) {
            T element = null;
            while (it.hasNext()) {
                T next = it.next();
                if (next == null) continue;
                if (element != null) {
                    return null;
                }
                element = next;
            }
            return element;
        }
        return null;
    }

    public static <E> Set<E> singletonOrEmpty(E element) {
        return element != null ? Collections.singleton(element) : Collections.emptySet();
    }

    @SafeVarargs
    public static <T> Set<T> nonEmptySet(T ... elements) {
        Set<T> asSet = CollectionsExt.immutableSet(true, elements);
        return asSet != null && asSet.isEmpty() ? null : asSet;
    }

    public static <E> E[] nonEmpty(E[] array) {
        return array != null && array.length == 0 ? null : array;
    }

    public static <T extends Collection<E>, E> T nonEmpty(T c) {
        return (T)(c != null && c.isEmpty() ? null : c);
    }

    public static <E> Collection<E> nonNull(Collection<E> c) {
        return c != null ? c : Collections.emptySet();
    }

    public static <E> Set<E> nonNull(Set<E> c) {
        return c != null ? c : Collections.emptySet();
    }

    public static <E> E[] nonNullArraySet(String name, Object value, E[] emptyArray) throws IllegalArgumentException {
        assert (emptyArray.length == 0);
        if (value == null) {
            return emptyArray;
        }
        Class<?> type = emptyArray.getClass();
        Class<?> valueType = value.getClass();
        if (valueType.isArray()) {
            if (type.isAssignableFrom(valueType)) {
                LinkedHashSet<Object> set = new LinkedHashSet<Object>(Arrays.asList((Object[])value));
                set.remove(null);
                return set.toArray(emptyArray);
            }
        } else if ((type = type.getComponentType()).isAssignableFrom(valueType)) {
            Object[] array = (Object[])Array.newInstance(type, 1);
            array[0] = value;
            return array;
        }
        throw new IllegalArgumentException(Errors.format((short)73, name, valueType));
    }

    public static <E> Set<E> createSetForType(Class<E> type, int count) {
        if (CodeList.class.isAssignableFrom(type)) {
            return new CodeListSet<E>(type);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return EnumSet.noneOf(type);
        }
        return JDK19.newLinkedHashSet(count);
    }

    @SafeVarargs
    public static <E> Set<E> immutableSet(boolean excludeNull, E ... array) {
        if (array == null) {
            return null;
        }
        switch (array.length) {
            case 1: {
                E element = array[0];
                if (element != null || !excludeNull) {
                    return Collections.singleton(element);
                }
            }
            case 0: {
                return Collections.emptySet();
            }
        }
        LinkedHashSet<E> set = new LinkedHashSet<E>(Arrays.asList(array));
        if (excludeNull) {
            set.remove(null);
        }
        return CollectionsExt.unmodifiableOrCopy(set);
    }

    public static <E> Set<E> unmodifiableOrCopy(Set<E> set) {
        if (set == null) {
            return null;
        }
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiableOrCopy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E> List<E> unmodifiableOrCopy(List<E> list) {
        if (list != null) {
            int length = list.size();
            switch (length) {
                case 0: {
                    list = Collections.emptyList();
                    break;
                }
                case 1: {
                    list = Collections.singletonList(list.get(0));
                    break;
                }
                default: {
                    if (list instanceof UnmodifiableArrayList) break;
                    if (list instanceof CheckedContainer) {
                        Object[] array = (Object[])Array.newInstance(((CheckedContainer)((Object)list)).getElementType(), length);
                        list = UnmodifiableArrayList.wrap(list.toArray(array));
                        break;
                    }
                    if (!(list instanceof List)) break;
                    list = Collections.unmodifiableList(list);
                }
            }
        }
        return list;
    }

    public static <E> Collection<E> modifiableCopy(Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        Class<?> type = collection.getClass();
        if (collection instanceof Set) {
            if (collection instanceof SortedSet) {
                if (type == TreeSet.class) {
                    return (Collection)((TreeSet)collection).clone();
                }
                return new TreeSet<E>(collection);
            }
            if (type == HashSet.class || type == LinkedHashSet.class) {
                return (Collection)((HashSet)collection).clone();
            }
            if (collection instanceof EnumSet) {
                return ((EnumSet)collection).clone();
            }
            if (collection instanceof CodeListSet) {
                return ((CodeListSet)collection).clone();
            }
            return new LinkedHashSet<E>(collection);
        }
        if (collection instanceof Queue) {
            if (type == LinkedList.class) {
                return (Collection)((LinkedList)collection).clone();
            }
            return new LinkedList<E>(collection);
        }
        if (type == ArrayList.class) {
            return (Collection)((ArrayList)collection).clone();
        }
        return new ArrayList<E>(collection);
    }

    public static <K, V> Map<K, V> modifiableCopy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        Class<?> type = map.getClass();
        if (map instanceof SortedMap) {
            if (type == TreeMap.class) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap<K, V>(map);
        }
        if (type == HashMap.class || type == LinkedHashMap.class) {
            return (Map)((HashMap)map).clone();
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> compact(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    return Collections.emptyMap();
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
            }
        }
        return map;
    }

    public static <E> List<E> snapshot(List<E> list) {
        if (list != null && !(list instanceof UnmodifiableArrayList)) {
            switch (list.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    return Collections.singletonList(list.get(0));
                }
            }
            return Arrays.asList(list.toArray());
        }
        return list;
    }

    public static <E> Set<E> copyPreserveOrder(Set<E> set) {
        if (set == null) {
            return null;
        }
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(set));
    }

    public static <E> HashSet<E> clone(HashSet<E> set) {
        return (HashSet)set.clone();
    }

    public static Collection<?> toCollection(final Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value);
            }
            return new AbstractList<Object>(){

                @Override
                public int size() {
                    return Array.getLength(value);
                }

                @Override
                public Object get(int index) {
                    return Array.get(value, index);
                }

                @Override
                public Object set(int index, Object value2) {
                    Object old = Array.get(value2, index);
                    Array.set(value2, index, value2);
                    return old;
                }
            };
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            for (Object element : (Iterable)value) {
                list.add(element);
            }
            return list;
        }
        if (value instanceof Iterator) {
            Iterator it = (Iterator)value;
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
        if (value instanceof Enumeration) {
            return Collections.list((Enumeration)value);
        }
        return Collections.singletonList(value);
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> valueClass) {
        assert (Numbers.primitiveToWrapper(valueClass) == valueClass) : valueClass;
        if (collection != null) {
            return collection.toArray((Object[])Array.newInstance(valueClass, collection.size()));
        }
        return null;
    }

    public static <K, V> Set<V> addToMultiValuesMap(Map<K, Set<V>> map, K key, V value) {
        return map.merge(key, Collections.singleton(value), (values, singleton) -> {
            Set dest = values.size() > 1 ? values : new LinkedHashSet(values);
            return dest.addAll(singleton) ? dest : values;
        });
    }

    public static <K, V> Set<V> removeFromMultiValuesMap(Map<K, Set<V>> map, K key, V value) {
        Set remaining = map.compute(key, (k, values) -> {
            if (values != null) {
                boolean isEmpty;
                switch (values.size()) {
                    case 0: {
                        isEmpty = true;
                        break;
                    }
                    case 1: {
                        isEmpty = values.contains(value);
                        break;
                    }
                    default: {
                        boolean bl = isEmpty = values.remove(value) && values.isEmpty();
                    }
                }
                if (isEmpty) {
                    return Collections.emptySet();
                }
            }
            return values;
        });
        if (remaining != null && remaining.isEmpty() && map.remove(key) != remaining) {
            throw new ConcurrentModificationException();
        }
        return remaining;
    }

    public static <E> Map<String, E> toCaseInsensitiveNameMap(Collection<Map.Entry<String, E>> entries, Locale namesLocale) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, E> map = JDK19.newLinkedHashMap(entries.size());
        HashSet<String> generated = new HashSet<String>();
        for (Map.Entry<String, E> entry : entries) {
            E value;
            String name = entry.getKey();
            E old = map.put(name, value = entry.getValue());
            if (old != null && !generated.remove(name)) {
                throw new InvalidParameterCardinalityException(Errors.format((short)202, name), name);
            }
            String lower = name.toLowerCase(namesLocale);
            if (name.equals(lower)) continue;
            if (generated.add(lower)) {
                map.putIfAbsent(lower, value);
                continue;
            }
            map.remove(lower);
        }
        return map;
    }

    public static boolean identityEquals(Iterator<?> it1, Iterator<?> it2) {
        while (it1.hasNext()) {
            if (it2.hasNext() && it1.next() == it2.next()) continue;
            return false;
        }
        return !it2.hasNext();
    }
}

