/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.IdentityConverter;
import org.apache.sis.converter.InstantConverter;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

abstract class DateConverter<T>
extends SystemConverter<Date, T> {
    private static final long serialVersionUID = 945435736679371963L;
    SystemConverter<T, Date> inverse;

    DateConverter(Class<T> targetClass) {
        super(Date.class, targetClass);
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public final ObjectConverter<T, Date> inverse() {
        return this.inverse;
    }

    public static final class Instant
    extends DateConverter<java.time.Instant> {
        private static final long serialVersionUID = 5727173560137117677L;
        static final Instant INSTANCE = new Instant();

        public static Instant provider() {
            return INSTANCE;
        }

        public Instant() {
            super(java.time.Instant.class);
            this.inverse = InstantConverter.Date.INSTANCE;
        }

        @Override
        public java.time.Instant apply(Date source) {
            if (source != null) {
                try {
                    return source.toInstant();
                }
                catch (UnsupportedOperationException e) {
                    throw new UnconvertibleObjectException(this.formatErrorMessage(source), e);
                }
            }
            return null;
        }
    }

    public static final class Timestamp
    extends DateConverter<java.sql.Timestamp> {
        private static final long serialVersionUID = 7629460512978844462L;

        public Timestamp() {
            super(java.sql.Timestamp.class);
            this.inverse = new IdentityConverter<java.sql.Timestamp, Date>(this.targetClass, Date.class, this);
        }

        @Override
        public java.sql.Timestamp apply(Date source) {
            if (source == null || source instanceof java.sql.Timestamp) {
                return (java.sql.Timestamp)source;
            }
            return new java.sql.Timestamp(source.getTime());
        }
    }

    public static final class SQL
    extends DateConverter<java.sql.Date> {
        private static final long serialVersionUID = -7444502675467008640L;

        public SQL() {
            super(java.sql.Date.class);
            this.inverse = new IdentityConverter<java.sql.Date, Date>(this.targetClass, Date.class, this);
        }

        @Override
        public java.sql.Date apply(Date source) {
            if (source == null || source instanceof java.sql.Date) {
                return (java.sql.Date)source;
            }
            return new java.sql.Date(source.getTime());
        }
    }

    public static final class Long
    extends DateConverter<java.lang.Long> {
        private static final long serialVersionUID = 5145114630594761657L;

        public Long() {
            super(java.lang.Long.class);
            this.inverse = new Inverse(this);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return Long.bijective();
        }

        @Override
        public java.lang.Long apply(Date source) {
            return source != null ? java.lang.Long.valueOf(source.getTime()) : null;
        }
    }

    private static final class Inverse
    extends SystemConverter<java.lang.Long, Date> {
        private static final long serialVersionUID = 5022624034871426299L;
        private final SystemConverter<Date, java.lang.Long> inverse;

        Inverse(SystemConverter<Date, java.lang.Long> inverse) {
            super(java.lang.Long.class, Date.class);
            this.inverse = inverse;
        }

        @Override
        public ObjectConverter<Date, java.lang.Long> inverse() {
            return this.inverse;
        }

        @Override
        public ObjectConverter<java.lang.Long, Date> unique() {
            return this.inverse.inverse();
        }

        @Override
        public Set<FunctionProperty> properties() {
            return this.inverse.properties();
        }

        @Override
        public Date apply(java.lang.Long target) {
            return target != null ? new Date(target) : null;
        }
    }
}

