/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.function.Supplier;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.SampleModelBuilder;
import org.apache.sis.io.stream.HyperRectangleWriter;
import org.apache.sis.math.Statistics;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.util.ArraysExt;

public final class ReformattedImage {
    private static final int TILE_DIVISOR = 16;
    private static final int NUM_COLOR_BANDS = 3;
    private final boolean singleBand;
    public short[] extraSamples;
    public final RenderedImage exportable;

    public ReformattedImage(RenderedImage image, Supplier<ImageProcessor> processor, boolean anyTileSize) {
        SampleModelBuilder factory;
        int numColors;
        boolean banded;
        int alphaBand = -1;
        boolean isAlphaPremultiplied = false;
        int numBands = ImageUtilities.getNumBands((RenderedImage)image);
        int visibleBand = ImageUtilities.getVisibleBand((RenderedImage)image);
        if (visibleBand >= 0) {
            banded = true;
            this.singleBand = true;
            if (visibleBand != 0) {
                int[] bands = ArraysExt.range((int)0, (int)numBands);
                System.arraycopy(bands, 0, bands, 1, visibleBand);
                bands[0] = visibleBand;
                image = processor.get().selectBands(image, bands);
            }
        } else {
            ColorModel cm = image.getColorModel();
            if (cm != null) {
                isAlphaPremultiplied = cm.isAlphaPremultiplied();
                alphaBand = cm.getNumColorComponents();
                if (alphaBand >= cm.getNumComponents()) {
                    alphaBand = -1;
                }
            }
            int expected = alphaBand < 0 ? 3 : 4;
            banded = numBands != expected;
            this.singleBand = numBands < expected;
        }
        int n = numColors = this.singleBand ? 1 : Math.min(numBands, 3);
        if (numBands > numColors) {
            this.extraSamples = new short[numBands - numColors];
            if (alphaBand >= 0) {
                this.extraSamples[alphaBand - numColors] = isAlphaPremultiplied ? 1 : 2;
            }
        }
        boolean reformat = false;
        SampleModel sm = image.getSampleModel();
        if (!HyperRectangleWriter.Builder.isSupported((SampleModel)sm) && (factory = new SampleModelBuilder(sm)).unpack(banded)) {
            sm = factory.build();
            reformat = true;
        }
        if (!anyTileSize && image.getNumXTiles() != 1) {
            Dimension tileSize = new Dimension(image.getTileWidth(), image.getTileHeight());
            if (((tileSize.width | tileSize.height) & 0xF) != 0) {
                int width = JDK18.ceilDiv((int)image.getWidth(), (int)16);
                int height = JDK18.ceilDiv((int)image.getHeight(), (int)16);
                tileSize.width = JDK18.ceilDiv((int)tileSize.width, (int)16);
                tileSize.height = JDK18.ceilDiv((int)tileSize.height, (int)16);
                tileSize = ImageLayout.DEFAULT.withPreferredTileSize(tileSize).suggestTileSize(width, height);
                tileSize.width *= 16;
                tileSize.height *= 16;
                sm = sm.createCompatibleSampleModel(tileSize.width, tileSize.height);
                reformat = true;
            }
        }
        if (reformat) {
            image = processor.get().reformat(image, sm);
        }
        this.exportable = image;
    }

    public double[][] statistics(int numBands) {
        block3: {
            Object property = this.exportable.getProperty("org.apache.sis.Statistics");
            if (property instanceof Statistics[]) {
                Statistics[] stats = (Statistics[])property;
                double[] min = new double[numBands];
                double[] max = new double[numBands];
                for (int i = 0; i < numBands; ++i) {
                    Statistics s = stats[i];
                    if (s != null && s.count() != 0) {
                        min[i] = s.minimum();
                        max[i] = s.maximum();
                        continue;
                    }
                    break block3;
                }
                return new double[][]{min, max};
            }
        }
        return new double[2][];
    }

    public int getSampleFormat() {
        SampleModel sm = this.exportable.getSampleModel();
        if (DataType.isUnsigned((SampleModel)sm)) {
            return 1;
        }
        if (DataType.isInteger((SampleModel)sm)) {
            return 2;
        }
        return 3;
    }

    public int getColorInterpretation() {
        ColorSpace cs;
        ColorModel cm = this.exportable.getColorModel();
        if (this.singleBand) {
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int last = icm.getMapSize() - 1;
                float scale = 255.0f / (float)last;
                boolean white = true;
                boolean black = true;
                for (int i = 0; i <= last; ++i) {
                    int expected = Math.round((float)i * scale);
                    if (black) {
                        boolean bl = black = icm.getRGB(i) == expected;
                    }
                    if (white) {
                        boolean bl = white = icm.getRGB(last - i) == expected;
                    }
                    if (!(black | white)) break;
                }
                if (black) {
                    return 1;
                }
                if (white) {
                    return 0;
                }
                return 3;
            }
            return 1;
        }
        if (cm != null && (cs = cm.getColorSpace()) != null) {
            switch (cs.getType()) {
                case 5: {
                    return 2;
                }
                case 11: {
                    return 5;
                }
                case 1: {
                    return 8;
                }
                case 3: {
                    return 6;
                }
            }
        }
        return 2;
    }
}

