/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.Serializable;
import java.util.OptionalInt;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.geotiff.base.Predictor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Strings;

public final class Compression
implements Serializable {
    private static final long serialVersionUID = 3916905136793784898L;
    public static final Compression NONE = new Compression(org.apache.sis.storage.geotiff.base.Compression.NONE, 0, Predictor.NONE);
    public static final Compression DEFLATE = new Compression(org.apache.sis.storage.geotiff.base.Compression.DEFLATE, -1, Predictor.NONE);
    public static final OptionKey<Compression> OPTION_KEY = new InternalOptionKey("TIFF_COMPRESSION", Compression.class);
    final org.apache.sis.storage.geotiff.base.Compression method;
    final int level;
    final Predictor predictor;

    private Compression(org.apache.sis.storage.geotiff.base.Compression method, int level, Predictor predictor) {
        this.method = method;
        this.level = level;
        this.predictor = predictor;
    }

    public Compression withLevel(int value) {
        if (value == 0) {
            return NONE;
        }
        if (value == this.level || !this.method.supportLevels()) {
            return this;
        }
        ArgumentChecks.ensureBetween((String)"level", (int)-1, (int)9, (int)value);
        return new Compression(this.method, (byte)value, this.predictor);
    }

    public OptionalInt level() {
        return this.level >= 0 ? OptionalInt.of(this.level) : OptionalInt.empty();
    }

    public Compression withPredictor(int value) {
        Predictor p = this.usePredictor() ? Predictor.supported(value) : Predictor.NONE;
        return p.equals((Object)this.predictor) ? this : new Compression(this.method, this.level, p);
    }

    public OptionalInt predictor() {
        return this.usePredictor() ? OptionalInt.of(this.predictor.code) : OptionalInt.empty();
    }

    final boolean usePredictor() {
        return this.level != 0;
    }

    public boolean equals(Object other) {
        if (other instanceof Compression) {
            Compression c = (Compression)other;
            return this.level == c.level && this.method.equals((Object)c.method) && this.predictor.equals((Object)c.predictor);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() + this.predictor.hashCode() + this.level;
    }

    public String toString() {
        return Strings.toString(Compression.class, (Object[])new Object[]{"method", this.method, "level", this.level != 0 ? Integer.valueOf(this.level) : null, "predictor", this.usePredictor() ? this.predictor : null});
    }
}

